/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.auth;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.ext.auth.AuthProvider;
import io.vertx.rxjava.ext.auth.authorization.Authorization;
import io.vertx.rxjava.ext.auth.authorization.Authorizations;
import rx.Single;

@RxGen(value=io.vertx.ext.auth.User.class)
public class User {
    public static final TypeArg<User> __TYPE_ARG = new TypeArg(obj -> new User((io.vertx.ext.auth.User)obj), User::getDelegate);
    private final io.vertx.ext.auth.User delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User that = (User)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public User(io.vertx.ext.auth.User delegate) {
        this.delegate = delegate;
    }

    public User(Object delegate) {
        this.delegate = (io.vertx.ext.auth.User)delegate;
    }

    public io.vertx.ext.auth.User getDelegate() {
        return this.delegate;
    }

    public static User fromName(String username) {
        User ret = User.newInstance(io.vertx.ext.auth.User.fromName((String)username));
        return ret;
    }

    public static User fromToken(String token) {
        User ret = User.newInstance(io.vertx.ext.auth.User.fromToken((String)token));
        return ret;
    }

    public static User create(JsonObject principal) {
        User ret = User.newInstance(io.vertx.ext.auth.User.create((JsonObject)principal));
        return ret;
    }

    public static User create(JsonObject principal, JsonObject attributes) {
        User ret = User.newInstance(io.vertx.ext.auth.User.create((JsonObject)principal, (JsonObject)attributes));
        return ret;
    }

    public String subject() {
        String ret = this.delegate.subject();
        return ret;
    }

    public JsonObject attributes() {
        JsonObject ret = this.delegate.attributes();
        return ret;
    }

    public boolean expired() {
        boolean ret = this.delegate.expired();
        return ret;
    }

    public boolean expired(int leeway) {
        boolean ret = this.delegate.expired(leeway);
        return ret;
    }

    public <T> T get(String key) {
        Object ret = this.delegate.get(key);
        return (T)ret;
    }

    public boolean containsKey(String key) {
        boolean ret = this.delegate.containsKey(key);
        return ret;
    }

    public Authorizations authorizations() {
        Authorizations ret = Authorizations.newInstance(this.delegate.authorizations());
        return ret;
    }

    @Deprecated
    public User isAuthorized(Authorization authority, Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.isAuthorized(authority.getDelegate(), resultHandler);
        return this;
    }

    @Deprecated
    public User isAuthorized(Authorization authority) {
        return this.isAuthorized(authority, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    @Deprecated
    public Single<Boolean> rxIsAuthorized(Authorization authority) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.isAuthorized(authority, (Handler<AsyncResult<Boolean>>)fut)));
    }

    @Deprecated
    public User isAuthorized(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.isAuthorized(authority, resultHandler);
        return this;
    }

    @Deprecated
    public User isAuthorized(String authority) {
        return this.isAuthorized(authority, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    @Deprecated
    public Single<Boolean> rxIsAuthorized(String authority) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.isAuthorized(authority, (Handler<AsyncResult<Boolean>>)fut)));
    }

    @Deprecated
    public User clearCache() {
        this.delegate.clearCache();
        return this;
    }

    public JsonObject principal() {
        JsonObject ret = this.delegate.principal();
        return ret;
    }

    @Deprecated
    public void setAuthProvider(AuthProvider authProvider) {
        this.delegate.setAuthProvider(authProvider.getDelegate());
    }

    public User merge(User other) {
        this.delegate.merge(other.getDelegate());
        return this;
    }

    public static User newInstance(io.vertx.ext.auth.User arg) {
        return arg != null ? new User(arg) : null;
    }
}

