/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.rest;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Objects;

public class ServiceDiscoveryRestEndpoint {
    public static final String DEFAULT_ROOT = "/discovery";
    private final ServiceDiscovery discovery;

    public static ServiceDiscoveryRestEndpoint create(Router router, ServiceDiscovery discovery) {
        return new ServiceDiscoveryRestEndpoint(router, discovery, DEFAULT_ROOT);
    }

    public static ServiceDiscoveryRestEndpoint create(Router router, ServiceDiscovery discovery, String root) {
        return new ServiceDiscoveryRestEndpoint(router, discovery, root);
    }

    private ServiceDiscoveryRestEndpoint(Router router, ServiceDiscovery discovery, String root) {
        Objects.requireNonNull(router);
        Objects.requireNonNull(discovery);
        Objects.requireNonNull(root);
        this.discovery = discovery;
        this.registerRoutes(router, root);
    }

    private void registerRoutes(Router router, String root) {
        router.get(root).handler(this::all);
        router.get(root + "/:uuid").handler(this::one);
        router.delete(root + "/:uuid").handler(this::unpublish);
        router.route().handler((Handler)BodyHandler.create());
        router.post(root).handler(this::publish);
        router.put(root + "/:uuid").handler(this::update);
    }

    private void update(RoutingContext routingContext) {
        JsonObject json;
        Record record;
        String uuid = routingContext.request().getParam("uuid");
        if (!uuid.equals((record = new Record(json = routingContext.getBodyAsJson())).getRegistration())) {
            routingContext.fail(400);
            return;
        }
        this.discovery.update(record, (Handler<AsyncResult<Record>>)((Handler)ar -> {
            if (ar.failed()) {
                routingContext.fail(ar.cause());
            } else {
                routingContext.response().setStatusCode(200).putHeader("Content-Type", "application/json").end(((Record)ar.result()).toJson().toString());
            }
        }));
    }

    private void unpublish(RoutingContext routingContext) {
        String uuid = routingContext.request().getParam("uuid");
        this.discovery.unpublish(uuid, (Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.failed()) {
                routingContext.fail(ar.cause());
            } else {
                routingContext.response().setStatusCode(204).end();
            }
        }));
    }

    private void one(RoutingContext routingContext) {
        this.discovery.getRecord(new JsonObject().put("registration", (Object)routingContext.request().getParam("uuid")), (Handler<AsyncResult<Record>>)((Handler)ar -> {
            if (ar.failed()) {
                routingContext.fail(ar.cause());
            } else if (ar.result() == null) {
                routingContext.response().setStatusCode(404).end();
            } else {
                routingContext.response().setStatusCode(200).putHeader("Content-Type", "application/json").end(((Record)ar.result()).toJson().toString());
            }
        }));
    }

    private void publish(RoutingContext routingContext) {
        JsonObject json = routingContext.getBodyAsJson();
        Record record = new Record(json);
        this.discovery.publish(record, (Handler<AsyncResult<Record>>)((Handler)ar -> {
            if (ar.failed()) {
                routingContext.fail(ar.cause());
            } else {
                routingContext.response().setStatusCode(201).putHeader("Content-Type", "application/json").end(((Record)ar.result()).toJson().toString());
            }
        }));
    }

    private void all(RoutingContext routingContext) {
        String query = routingContext.request().params().get("query");
        JsonObject filter = new JsonObject();
        if (query != null) {
            try {
                String decoded = URLDecoder.decode(query, "UTF-8");
                filter = new JsonObject(decoded);
            }
            catch (UnsupportedEncodingException e) {
                routingContext.fail((Throwable)e);
                return;
            }
        }
        this.discovery.getRecords(filter, (Handler<AsyncResult<List<Record>>>)((Handler)ar -> {
            if (ar.failed()) {
                routingContext.fail(ar.cause());
            } else {
                JsonArray jsonArray = ((List)ar.result()).stream().map(Record::toJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
                routingContext.json((Object)jsonArray);
            }
        }));
    }
}

