/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.CursorType;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.client.AsyncFindIterable;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.internal.Publishers;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FindPublisherImpl<TResult>
implements FindPublisher<TResult> {
    private final AsyncFindIterable<TResult> wrapped;

    FindPublisherImpl(AsyncFindIterable<TResult> wrapped) {
        this.wrapped = (AsyncFindIterable)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public Publisher<TResult> first() {
        return Publishers.publish(arg_0 -> this.wrapped.first(arg_0));
    }

    @Override
    public FindPublisher<TResult> filter(Bson filter) {
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public FindPublisher<TResult> limit(int limit) {
        this.wrapped.limit(limit);
        return this;
    }

    @Override
    public FindPublisher<TResult> skip(int skip) {
        this.wrapped.skip(skip);
        return this;
    }

    @Override
    public FindPublisher<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public FindPublisher<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.wrapped.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public FindPublisher<TResult> projection(Bson projection) {
        this.wrapped.projection(projection);
        return this;
    }

    @Override
    public FindPublisher<TResult> sort(Bson sort) {
        this.wrapped.sort(sort);
        return this;
    }

    @Override
    public FindPublisher<TResult> noCursorTimeout(boolean noCursorTimeout) {
        this.wrapped.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    @Deprecated
    public FindPublisher<TResult> oplogReplay(boolean oplogReplay) {
        this.wrapped.oplogReplay(oplogReplay);
        return this;
    }

    @Override
    public FindPublisher<TResult> partial(boolean partial) {
        this.wrapped.partial(partial);
        return this;
    }

    @Override
    public FindPublisher<TResult> cursorType(CursorType cursorType) {
        this.wrapped.cursorType(cursorType);
        return this;
    }

    @Override
    public FindPublisher<TResult> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    @Override
    public FindPublisher<TResult> comment(String comment) {
        this.wrapped.comment(comment);
        return this;
    }

    @Override
    public FindPublisher<TResult> hint(Bson hint) {
        this.wrapped.hint(hint);
        return this;
    }

    @Override
    public FindPublisher<TResult> hintString(String hint) {
        this.wrapped.hintString(hint);
        return this;
    }

    @Override
    public FindPublisher<TResult> max(Bson max) {
        this.wrapped.max(max);
        return this;
    }

    @Override
    public FindPublisher<TResult> min(Bson min) {
        this.wrapped.min(min);
        return this;
    }

    @Override
    public FindPublisher<TResult> returnKey(boolean returnKey) {
        this.wrapped.returnKey(returnKey);
        return this;
    }

    @Override
    public FindPublisher<TResult> showRecordId(boolean showRecordId) {
        this.wrapped.showRecordId(showRecordId);
        return this;
    }

    @Override
    public FindPublisher<TResult> batchSize(int batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    @Override
    public FindPublisher<TResult> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.wrapped.allowDiskUse(allowDiskUse);
        return this;
    }

    public void subscribe(Subscriber<? super TResult> s) {
        Publishers.publish(this.wrapped).subscribe(s);
    }
}

