/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.io;

import io.termd.core.util.Helper;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.function.Consumer;

public class BinaryDecoder {
    private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
    private CharsetDecoder decoder;
    private ByteBuffer bBuf;
    private final CharBuffer cBuf;
    private final Consumer<int[]> onChar;

    public BinaryDecoder(Charset charset, Consumer<int[]> onChar) {
        this(2, charset, onChar);
    }

    public BinaryDecoder(int initialSize, Charset charset, Consumer<int[]> onChar) {
        if (initialSize < 2) {
            throw new IllegalArgumentException("Initial size must be at least 2");
        }
        this.decoder = charset.newDecoder();
        this.bBuf = EMPTY;
        this.cBuf = CharBuffer.allocate(initialSize);
        this.onChar = onChar;
    }

    public void setCharset(Charset charset) {
        this.decoder = charset.newDecoder();
    }

    public void write(byte[] data) {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int start, int len) {
        CoderResult result;
        int remaining = this.bBuf.remaining();
        if (len > remaining) {
            ByteBuffer tmp = this.bBuf;
            int length = tmp.position() + len;
            this.bBuf = ByteBuffer.allocate(length);
            tmp.flip();
            this.bBuf.put(tmp);
        }
        this.bBuf.put(data, start, len);
        this.bBuf.flip();
        do {
            IntBuffer iBuf = IntBuffer.allocate(this.bBuf.remaining());
            result = this.decoder.decode(this.bBuf, this.cBuf, false);
            this.cBuf.flip();
            while (this.cBuf.hasRemaining()) {
                char c = this.cBuf.get();
                if (Character.isSurrogate(c)) {
                    if (Character.isHighSurrogate(c)) {
                        if (this.cBuf.hasRemaining()) {
                            char low = this.cBuf.get();
                            if (Character.isLowSurrogate(low)) {
                                int codePoint = Character.toCodePoint(c, low);
                                if (Character.isValidCodePoint(codePoint)) {
                                    iBuf.put(codePoint);
                                    continue;
                                }
                                throw new UnsupportedOperationException("Handle me gracefully");
                            }
                            throw new UnsupportedOperationException("Handle me gracefully");
                        }
                        throw new UnsupportedOperationException("Handle me gracefully");
                    }
                    throw new UnsupportedOperationException("Handle me gracefully");
                }
                iBuf.put(c);
            }
            iBuf.flip();
            int[] codePoints = new int[iBuf.limit()];
            iBuf.get(codePoints);
            this.onChar.accept(codePoints);
            this.cBuf.compact();
        } while (result.isOverflow());
        if (result.isUnderflow()) {
            if (this.bBuf.hasRemaining()) {
                Helper.noop();
            } else {
                Helper.noop();
            }
        } else {
            throw new UnsupportedOperationException("Handle me gracefully");
        }
        this.bBuf.compact();
    }
}

