/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.impl.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class JsonObjectSchema
extends JsonObject
implements JsonSchema {
    private static final List<String> POINTER_KEYWORD = Arrays.asList("$ref", "$id", "$anchor", "$dynamicRef", "$dynamicAnchor", "$schema");
    private boolean annotated;

    public JsonObjectSchema(JsonObject json) {
        super(json.getMap());
        this.annotated = json.containsKey("__absolute_uri__") || json.containsKey("__absolute_ref__") || json.containsKey("__absolute_recursive_ref__");
    }

    @Override
    public JsonSchema annotate(String key, String value) {
        switch (key) {
            case "__absolute_uri__": {
                this.annotated = true;
                this.put("__absolute_uri__", value);
                break;
            }
            case "__absolute_ref__": {
                this.annotated = true;
                this.put("__absolute_ref__", value);
                break;
            }
            case "__absolute_recursive_ref__": {
                this.annotated = true;
                this.put("__absolute_recursive_ref__", value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported annotation: " + key);
            }
        }
        return this;
    }

    @Override
    public <R> R get(String key, R fallback) {
        return (R)this.getValue(key, fallback);
    }

    @Override
    public <R> R get(String key) {
        return (R)this.getValue(key);
    }

    @Override
    public Set<String> fieldNames() {
        if (this.annotated) {
            HashSet<String> filteredFieldNames = new HashSet<String>(super.fieldNames());
            filteredFieldNames.remove("__absolute_uri__");
            filteredFieldNames.remove("__absolute_ref__");
            filteredFieldNames.remove("__absolute_recursive_ref__");
            return filteredFieldNames;
        }
        return super.fieldNames();
    }

    @Override
    public JsonObject resolve() {
        JsonObject tree = this.copy();
        HashMap<String, List<Ref>> pointers = new HashMap<String, List<Ref>>();
        JsonObjectSchema.findRefsAndClean(tree, "#", "", pointers);
        HashMap<String, JsonObject> anchors = new HashMap<String, JsonObject>();
        anchors.put("", tree);
        JsonObject dynamicAnchors = new JsonObject();
        pointers.computeIfAbsent("$id", key -> Collections.emptyList()).forEach(item -> {
            String ref = item.ref;
            String path = item.path;
            JsonObject obj = item.obj;
            if (anchors.containsKey(ref)) {
                throw new SchemaException(this, "$id: '" + ref + "' defined more than once at: " + path);
            }
            anchors.put(ref, obj);
        });
        pointers.computeIfAbsent("$anchor", key -> Collections.emptyList()).forEach(item -> {
            String ref = item.ref;
            String path = item.path;
            JsonObject obj = item.obj;
            String id = item.id;
            String fullRef = id + "#" + ref;
            if (anchors.containsKey(fullRef)) {
                throw new SchemaException(this, "$anchor: '" + ref + "' defined more than once at: " + path);
            }
            anchors.put(fullRef, obj);
        });
        pointers.computeIfAbsent("$dynamicAnchor", key -> Collections.emptyList()).forEach(item -> {
            String ref = item.ref;
            String path = item.path;
            JsonObject obj = item.obj;
            if (dynamicAnchors.containsKey("#" + ref)) {
                throw new SchemaException(this, "$dynamicAnchor: '" + ref + "' defined more than once at: " + path);
            }
            dynamicAnchors.put("#" + ref, (Object)obj);
        });
        pointers.computeIfAbsent("$ref", key -> Collections.emptyList()).forEach(item -> {
            String ref = item.ref;
            String prop = item.prop;
            JsonObject obj = item.obj;
            String id = item.id;
            obj.remove(prop);
            String decodedRef = URIDecoder.decodeURIComponent((String)ref);
            String fullRef = decodedRef.charAt(0) != '#' ? decodedRef : id + decodedRef;
            obj.mergeIn(new JsonObject(JsonObjectSchema.resolveUri(this, fullRef, anchors).stream().filter(kv -> !POINTER_KEYWORD.contains(kv.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        });
        pointers.computeIfAbsent("$dynamicRef", key -> Collections.emptyList()).forEach(item -> {
            String ref = item.ref;
            String prop = item.prop;
            JsonObject obj = item.obj;
            if (!dynamicAnchors.containsKey(ref)) {
                throw new SchemaException(this, "Can't resolve $dynamicAnchor: '" + ref + "'");
            }
            obj.remove(prop);
            obj.mergeIn(new JsonObject(dynamicAnchors.getJsonObject(ref).stream().filter(kv -> !POINTER_KEYWORD.contains(kv.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        });
        return tree;
    }

    private static JsonObject resolveUri(JsonSchema schema, String uri, Map<String, JsonObject> anchors) {
        String path;
        String[] parts = uri.split("#", 2);
        boolean hashPresent = parts.length == 2 && parts[1] != null;
        String prefix = parts[0];
        String string = path = hashPresent ? parts[1] : null;
        if (hashPresent && path.charAt(0) != '/') {
            if (anchors.containsKey(uri)) {
                return anchors.get(uri);
            }
            throw new SchemaException(schema, "Can't resolve '" + uri + "', only internal refs are supported.");
        }
        if (!anchors.containsKey(prefix)) {
            throw new SchemaException(schema, "Can't resolve '" + uri + "', only internal refs are supported.");
        }
        if (!hashPresent) {
            return anchors.get(prefix);
        }
        String[] paths = path.split("/");
        JsonObject value = anchors.get(prefix).copy();
        for (int i = 1; i < paths.length; ++i) {
            if ((value = value.getJsonObject(Utils.Pointers.unescape(paths[i]))) != null) continue;
            throw new SchemaException(schema, "Can't resolve '" + uri + "', only internal refs are supported.");
        }
        return value;
    }

    private static void findRefsAndClean(Object obj, String path, String id, Map<String, List<Ref>> pointers) {
        if (!Utils.Objects.isObject(obj)) {
            return;
        }
        if (obj instanceof JsonObject) {
            JsonObject json = (JsonObject)obj;
            json.remove("__absolute_uri__");
            json.remove("__absolute_ref__");
            json.remove("__absolute_recursive_ref__");
            if (json.containsKey("$id") || json.containsKey("id")) {
                id = json.getString("$id", json.getString("id"));
            }
            for (String prop : json.fieldNames()) {
                if (POINTER_KEYWORD.contains(prop)) {
                    pointers.computeIfAbsent(prop, key -> new ArrayList()).add(new Ref(json.getString(prop), json, prop, path, id));
                }
                JsonObjectSchema.findRefsAndClean(json.getValue(prop), path + "/" + Utils.Pointers.encode(prop), id, pointers);
            }
        }
    }

    private static final class Ref {
        final String ref;
        final JsonObject obj;
        final String prop;
        final String path;
        final String id;

        Ref(String ref, JsonObject obj, String prop, String path, String id) {
            this.ref = ref;
            this.obj = obj;
            this.prop = prop;
            this.path = path;
            this.id = id;
        }
    }
}

