/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.micrometer.MicrometerMetricsOptions;
import io.vertx.micrometer.backends.BackendRegistries;
import io.vertx.micrometer.backends.BackendRegistry;
import io.vertx.micrometer.impl.VertxMetricsImpl;

public class VertxMetricsFactoryImpl
implements VertxMetricsFactory {
    public VertxMetrics metrics(VertxOptions vertxOptions) {
        MetricsOptions metricsOptions = vertxOptions.getMetricsOptions();
        MicrometerMetricsOptions options = metricsOptions instanceof MicrometerMetricsOptions ? (MicrometerMetricsOptions)metricsOptions : new MicrometerMetricsOptions(metricsOptions.toJson());
        BackendRegistry backendRegistry = BackendRegistries.setupBackend(options);
        VertxMetricsImpl metrics = new VertxMetricsImpl(options, backendRegistry);
        metrics.init();
        if (options.isJvmMetricsEnabled()) {
            new ClassLoaderMetrics().bindTo(backendRegistry.getMeterRegistry());
            new JvmMemoryMetrics().bindTo(backendRegistry.getMeterRegistry());
            new JvmGcMetrics().bindTo(backendRegistry.getMeterRegistry());
            new ProcessorMetrics().bindTo(backendRegistry.getMeterRegistry());
            new JvmThreadMetrics().bindTo(backendRegistry.getMeterRegistry());
        }
        return metrics;
    }

    public MetricsOptions newOptions(MetricsOptions options) {
        if (options instanceof MicrometerMetricsOptions) {
            return new MicrometerMetricsOptions((MicrometerMetricsOptions)options);
        }
        return super.newOptions(options);
    }

    public MetricsOptions newOptions() {
        return this.newOptions((JsonObject)null);
    }

    public MetricsOptions newOptions(JsonObject jsonObject) {
        return jsonObject == null ? new MicrometerMetricsOptions() : new MicrometerMetricsOptions(jsonObject);
    }
}

