/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CountOptionsConverter;
import io.vertx.ext.mongo.impl.JsonObjectBsonAdapter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

@DataObject(generateConverter=true)
public class CountOptions {
    private JsonObject hint;
    private String hintString;
    private Integer limit;
    private Integer skip;
    private Long maxTime;
    private CollationOptions collation;

    public CountOptions() {
        this.hint = null;
        this.hintString = null;
        this.limit = null;
        this.skip = null;
        this.maxTime = null;
        this.collation = null;
    }

    public CountOptions(CountOptions countOptions) {
        this.hint = countOptions.getHint();
        this.hintString = countOptions.getHintString();
        this.limit = countOptions.getLimit();
        this.skip = countOptions.getSkip();
        this.maxTime = countOptions.getMaxTime();
        this.collation = countOptions.getCollation();
    }

    public CountOptions(JsonObject json) {
        CountOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CountOptionsConverter.toJson(this, json);
        return json;
    }

    public com.mongodb.client.model.CountOptions toMongoDriverObject() {
        com.mongodb.client.model.CountOptions options = new com.mongodb.client.model.CountOptions();
        if (this.limit != null) {
            options.limit(this.limit.intValue());
        }
        if (this.skip != null) {
            options.skip(this.skip.intValue());
        }
        if (this.maxTime != null) {
            options.maxTime(this.maxTime.longValue(), TimeUnit.MILLISECONDS);
        }
        if (this.collation != null) {
            options.collation(this.collation.toMongoDriverObject());
        }
        if (this.hint != null) {
            options.hint((Bson)new JsonObjectBsonAdapter(this.hint));
        }
        if (this.hintString != null) {
            options.hintString(this.hintString);
        }
        return options;
    }

    public JsonObject getHint() {
        return this.hint;
    }

    public CountOptions setHint(JsonObject hint) {
        this.hint = hint;
        return this;
    }

    public String getHintString() {
        return this.hintString;
    }

    public CountOptions setHintString(String hint) {
        this.hintString = hint;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public CountOptions setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public CountOptions setSkip(Integer skip) {
        this.skip = skip;
        return this;
    }

    public Long getMaxTime() {
        return this.maxTime;
    }

    public CountOptions setMaxTime(Long maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    public CollationOptions getCollation() {
        return this.collation;
    }

    public CountOptions setCollation(CollationOptions collation) {
        this.collation = collation;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountOptions that = (CountOptions)o;
        return Objects.equals(this.hint, that.hint) && Objects.equals(this.hintString, that.hintString) && Objects.equals(this.limit, that.limit) && Objects.equals(this.skip, that.skip) && Objects.equals(this.maxTime, that.maxTime) && Objects.equals(this.collation, that.collation);
    }

    public int hashCode() {
        return Objects.hash(this.hint, this.hintString, this.limit, this.skip, this.maxTime, this.collation);
    }

    public String toString() {
        return "CountOptions{hint=" + this.hint + ", hintString='" + this.hintString + '\'' + ", limit=" + this.limit + ", skip=" + this.skip + ", maxTime=" + this.maxTime + ", collation=" + this.collation + '}';
    }
}

