/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class CacheAddPartitionLostListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1251584;
    public static final int RESPONSE_MESSAGE_TYPE = 1251585;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 17;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 30;
    private static final int EVENT_CACHE_PARTITION_LOST_PARTITION_ID_FIELD_OFFSET = 16;
    private static final int EVENT_CACHE_PARTITION_LOST_UUID_FIELD_OFFSET = 20;
    private static final int EVENT_CACHE_PARTITION_LOST_INITIAL_FRAME_SIZE = 37;
    private static final int EVENT_CACHE_PARTITION_LOST_MESSAGE_TYPE = 1251586;

    private CacheAddPartitionLostListenerCodec() {
    }

    public static ClientMessage encodeRequest(String name, boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Cache.AddPartitionLostListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1251584);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, localOnly);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1251585);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static UUID decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator.next();
        return FixedSizeTypesCodec.decodeUUID(initialFrame.content, 13);
    }

    public static ClientMessage encodeCachePartitionLostEvent(int partitionId, UUID uuid) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[37], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1251586);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, partitionId);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 20, uuid);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 1251586) {
                ClientMessage.Frame initialFrame = iterator.next();
                int partitionId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                UUID uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 20);
                this.handleCachePartitionLostEvent(partitionId, uuid);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleCachePartitionLostEvent(int var1, UUID var2);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public boolean localOnly;
    }
}

