/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class CacheManagementConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x131100;
    public static final int RESPONSE_MESSAGE_TYPE = 0x131101;
    private static final int REQUEST_IS_STAT_FIELD_OFFSET = 16;
    private static final int REQUEST_ENABLED_FIELD_OFFSET = 17;
    private static final int REQUEST_UUID_FIELD_OFFSET = 18;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 35;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private CacheManagementConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, boolean isStat, boolean enabled, UUID uuid) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Cache.ManagementConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[35], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x131100);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, isStat);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 17, enabled);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 18, uuid);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.isStat = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 17);
        request.uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 18);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x131101);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public boolean isStat;
        public boolean enabled;
        public UUID uuid;
    }
}

