/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.impl;

import com.hazelcast.internal.monitor.impl.LocalTopicStatsImpl;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.topic.impl.PublishAllOperation;
import com.hazelcast.topic.impl.PublishOperation;
import com.hazelcast.topic.impl.TopicProxy;
import com.hazelcast.topic.impl.TopicService;
import java.util.Collection;
import javax.annotation.Nonnull;

public class TotalOrderedTopicProxy<E>
extends TopicProxy<E> {
    private final OperationService operationService;
    private final int partitionId;
    private final LocalTopicStatsImpl topicStats;

    public TotalOrderedTopicProxy(String name, NodeEngine nodeEngine, TopicService service) {
        super(name, nodeEngine, service);
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
        this.operationService = nodeEngine.getOperationService();
        this.topicStats = service.getLocalTopicStats(name);
    }

    @Override
    public void publish(@Nonnull E message) {
        Preconditions.checkNotNull(message, "Null message is not allowed!");
        Operation operation = new PublishOperation(this.getName(), this.toData(message)).setPartitionId(this.partitionId);
        InvocationFuture f = this.invokeOnPartition(operation);
        ((InternalCompletableFuture)f).joinInternal();
    }

    public InternalCompletableFuture<Void> publishAsync(@Nonnull E message) {
        Preconditions.checkNotNull(message, "Null message is not allowed!");
        PublishOperation op = new PublishOperation(this.getName(), this.toData(message));
        return this.publishInternalAsync(op);
    }

    @Override
    public void publishAll(@Nonnull Collection<? extends E> messages) {
        ((InternalCompletableFuture)this.publishAllAsync((Collection)messages)).joinInternal();
    }

    public InternalCompletableFuture<Void> publishAllAsync(@Nonnull Collection<? extends E> messages) {
        Preconditions.checkNotNull(messages, "Null message is not allowed!");
        Preconditions.checkNoNullInside(messages, "Null message is not allowed!");
        PublishAllOperation op = new PublishAllOperation(this.getName(), this.toDataArray(messages));
        return this.publishInternalAsync(op);
    }

    private InternalCompletableFuture<Void> publishInternalAsync(Operation operation) {
        try {
            return this.operationService.invokeOnPartition("hz:impl:operationService", operation, this.partitionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }
}

