/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.util;

import java.util.regex.Pattern;

public final class Strings {
    public static String globToRegex(String pattern) {
        String DOT = ".";
        StringBuilder out = new StringBuilder(pattern.length());
        out.append('^');
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        out.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            out.append('\\');
                        }
                        default: {
                            out.append('\\');
                        }
                    }
                    out.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass == 0) {
                        out.append(".*");
                        continue block16;
                    }
                    out.append('*');
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        out.append(".");
                        continue block16;
                    }
                    out.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    out.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    out.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        out.append('\\');
                    }
                    out.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        out.append('^');
                        continue block16;
                    }
                    out.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    out.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    out.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        out.append('|');
                        continue block16;
                    }
                    out.append(',');
                    continue block16;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        out.append('$');
        return out.toString();
    }

    public static final Pattern globToPattern(String glob) {
        return Pattern.compile(Strings.globToRegex(glob));
    }

    private Strings() {
    }
}

