/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.util;

import co.paralleluniverse.concurrent.util.OwnedSynchronizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class OwnedSynchronizer1
extends OwnedSynchronizer {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition available = this.lock.newCondition();
    private volatile boolean ownerBlocking;

    OwnedSynchronizer1() {
    }

    @Override
    public void register() {
        this.ownerBlocking = true;
        this.lock.lock();
    }

    @Override
    public void unregister() {
        this.ownerBlocking = false;
        this.lock.unlock();
    }

    @Override
    public boolean shouldSignal() {
        return this.ownerBlocking;
    }

    @Override
    public void signal() {
        this.lock.lock();
        try {
            this.available.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void await() throws InterruptedException {
        this.available.await();
    }

    @Override
    public void await(long timeout, TimeUnit unit) throws InterruptedException {
        this.available.await(timeout, unit);
    }

    @Override
    public long awaitNanos(long nanos) throws InterruptedException {
        return this.available.awaitNanos(nanos);
    }
}

