/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.shell.term.TelnetTermOptionsConverter;
import java.nio.charset.StandardCharsets;
import java.util.Map;

@DataObject(generateConverter=true)
public class TelnetTermOptions
extends NetServerOptions {
    public static final boolean DEFAULT_IN_BINARY = true;
    public static final boolean DEFAULT_OUT_BINARY = true;
    public static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    public static final String DEFAULT_INPUTRC = "/io/vertx/ext/shell/inputrc";
    private boolean outBinary;
    private boolean inBinary;
    private String charset;
    private String intputrc;

    public TelnetTermOptions() {
        this.init();
    }

    public TelnetTermOptions(TelnetTermOptions other) {
        super((NetServerOptions)other);
        this.outBinary = other.outBinary;
        this.inBinary = other.inBinary;
        this.charset = other.charset;
        this.intputrc = other.intputrc;
    }

    public TelnetTermOptions(JsonObject json) {
        super(json);
        this.init();
        TelnetTermOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    private void init() {
        this.outBinary = true;
        this.inBinary = true;
        this.charset = DEFAULT_CHARSET;
        this.intputrc = DEFAULT_INPUTRC;
    }

    public TelnetTermOptions setSendBufferSize(int sendBufferSize) {
        return (TelnetTermOptions)super.setSendBufferSize(sendBufferSize);
    }

    public TelnetTermOptions setReceiveBufferSize(int receiveBufferSize) {
        return (TelnetTermOptions)super.setReceiveBufferSize(receiveBufferSize);
    }

    public TelnetTermOptions setReuseAddress(boolean reuseAddress) {
        return (TelnetTermOptions)super.setReuseAddress(reuseAddress);
    }

    public TelnetTermOptions setTrafficClass(int trafficClass) {
        return (TelnetTermOptions)super.setTrafficClass(trafficClass);
    }

    public TelnetTermOptions setTcpNoDelay(boolean tcpNoDelay) {
        return (TelnetTermOptions)super.setTcpNoDelay(tcpNoDelay);
    }

    public TelnetTermOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        return (TelnetTermOptions)super.setTcpKeepAlive(tcpKeepAlive);
    }

    public TelnetTermOptions setSoLinger(int soLinger) {
        return (TelnetTermOptions)super.setSoLinger(soLinger);
    }

    public TelnetTermOptions setIdleTimeout(int idleTimeout) {
        return (TelnetTermOptions)super.setIdleTimeout(idleTimeout);
    }

    public TelnetTermOptions setSsl(boolean ssl) {
        return (TelnetTermOptions)super.setSsl(ssl);
    }

    public TelnetTermOptions setKeyStoreOptions(JksOptions options) {
        return (TelnetTermOptions)super.setKeyStoreOptions(options);
    }

    public TelnetTermOptions setPfxKeyCertOptions(PfxOptions options) {
        return (TelnetTermOptions)super.setPfxKeyCertOptions(options);
    }

    public TelnetTermOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (TelnetTermOptions)super.setPemKeyCertOptions(options);
    }

    public TelnetTermOptions setTrustStoreOptions(JksOptions options) {
        return (TelnetTermOptions)super.setTrustStoreOptions(options);
    }

    public TelnetTermOptions setPfxTrustOptions(PfxOptions options) {
        return (TelnetTermOptions)super.setPfxTrustOptions(options);
    }

    public TelnetTermOptions setPemTrustOptions(PemTrustOptions options) {
        return (TelnetTermOptions)super.setPemTrustOptions(options);
    }

    public TelnetTermOptions addEnabledCipherSuite(String suite) {
        return (TelnetTermOptions)super.addEnabledCipherSuite(suite);
    }

    public TelnetTermOptions addCrlPath(String crlPath) throws NullPointerException {
        return (TelnetTermOptions)super.addCrlPath(crlPath);
    }

    public TelnetTermOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (TelnetTermOptions)super.addCrlValue(crlValue);
    }

    public TelnetTermOptions setAcceptBacklog(int acceptBacklog) {
        return (TelnetTermOptions)super.setAcceptBacklog(acceptBacklog);
    }

    public TelnetTermOptions setHost(String host) {
        return (TelnetTermOptions)super.setHost(host);
    }

    public TelnetTermOptions setPort(int port) {
        return (TelnetTermOptions)super.setPort(port);
    }

    public boolean getOutBinary() {
        return this.outBinary;
    }

    public TelnetTermOptions setOutBinary(boolean outBinary) {
        this.outBinary = outBinary;
        return this;
    }

    public boolean getInBinary() {
        return this.inBinary;
    }

    public TelnetTermOptions setInBinary(boolean inBinary) {
        this.inBinary = inBinary;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public TelnetTermOptions setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getIntputrc() {
        return this.intputrc;
    }

    public TelnetTermOptions setIntputrc(String intputrc) {
        this.intputrc = intputrc;
        return this;
    }
}

