/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.redis.client.Command;
import java.nio.charset.StandardCharsets;

public class CommandImpl
implements Command {
    private final String command;
    private final byte[] bytes;
    private final int arity;
    private final boolean multiKey;
    private final int firstKey;
    private final int lastKey;
    private final int interval;
    private final boolean keyless;
    private final boolean write;
    private final boolean readOnly;
    private final boolean movable;
    private final boolean pubsub;

    public CommandImpl(String command, int arity, int firstKey, int lastKey, int interval, boolean write, boolean readOnly, boolean movable, boolean pubsub) {
        this.command = command;
        this.bytes = ("$" + command.length() + "\r\n" + command + "\r\n").getBytes(StandardCharsets.ISO_8859_1);
        this.arity = arity;
        this.firstKey = firstKey;
        this.lastKey = lastKey;
        this.interval = interval;
        this.multiKey = lastKey < 0;
        this.keyless = interval == 0 && !movable;
        this.write = write;
        this.readOnly = readOnly;
        this.movable = movable;
        this.pubsub = pubsub;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public boolean isMultiKey() {
        return this.multiKey;
    }

    @Override
    public int getFirstKey() {
        return this.firstKey;
    }

    @Override
    public int getLastKey() {
        return this.lastKey;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public boolean isKeyless() {
        return this.keyless;
    }

    @Override
    public boolean isWrite() {
        return this.write;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public boolean isPubSub() {
        return this.pubsub;
    }

    public String toString() {
        return this.command;
    }
}

