/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.net.SocketAddress;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class RedisURI {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 6379;
    private final SocketAddress socketAddress;
    private final String user;
    private final String password;
    private final Integer select;
    private final boolean ssl;
    private final boolean unix;
    private final Map<String, String> params;

    public RedisURI(RedisURI base, String host, int port) {
        this.socketAddress = SocketAddress.inetSocketAddress((int)port, (String)host);
        this.unix = false;
        this.user = base.user;
        this.password = base.password;
        this.select = base.select;
        this.ssl = base.ssl;
        this.params = base.params;
    }

    public RedisURI(String connectionString) {
        try {
            URI uri = new URI(connectionString);
            String host = uri.getHost() == null ? DEFAULT_HOST : uri.getHost();
            int port = uri.getPort() == -1 ? 6379 : uri.getPort();
            String path = uri.getPath() == null || uri.getPath().isEmpty() ? "/" : uri.getPath();
            this.params = RedisURI.parseQuery(uri);
            switch (uri.getScheme()) {
                case "rediss": {
                    this.ssl = true;
                    this.unix = false;
                    this.socketAddress = SocketAddress.inetSocketAddress((int)port, (String)host);
                    if (path.length() > 1) {
                        this.select = Integer.parseInt(uri.getPath().substring(1));
                        break;
                    }
                    if (this.params.containsKey("db")) {
                        this.select = Integer.parseInt(this.params.get("db"));
                        break;
                    }
                    this.select = null;
                    break;
                }
                case "redis": {
                    this.ssl = false;
                    this.unix = false;
                    this.socketAddress = SocketAddress.inetSocketAddress((int)port, (String)host);
                    if (path.length() > 1) {
                        this.select = Integer.parseInt(uri.getPath().substring(1));
                        break;
                    }
                    if (this.params.containsKey("db")) {
                        this.select = Integer.parseInt(this.params.get("db"));
                        break;
                    }
                    this.select = null;
                    break;
                }
                case "unix": {
                    this.ssl = false;
                    this.unix = true;
                    this.socketAddress = SocketAddress.domainSocketAddress((String)path);
                    if (this.params.containsKey("db")) {
                        this.select = Integer.parseInt(this.params.get("db"));
                        break;
                    }
                    this.select = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Redis connection string scheme [" + uri.getScheme() + "]");
                }
            }
            String userInfo = uri.getRawUserInfo();
            if (userInfo != null) {
                int sep = userInfo.indexOf(58);
                if (sep != -1) {
                    this.user = sep > 0 ? RedisURI.urlDecode(userInfo.substring(0, sep)) : (String)this.params.getOrDefault("user", null);
                    this.password = RedisURI.urlDecode(userInfo.substring(sep + 1));
                } else {
                    this.user = this.params.getOrDefault("user", null);
                    this.password = this.params.getOrDefault("password", null);
                }
            } else {
                this.user = this.params.getOrDefault("user", null);
                this.password = this.params.getOrDefault("password", null);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse the connection string", e);
        }
    }

    private static String urlDecode(String raw) {
        try {
            return URLDecoder.decode(raw, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> parseQuery(URI uri) {
        if (uri.getQuery() != null) {
            HashMap<String, String> query = new HashMap<String, String>();
            for (String kv : uri.getQuery().split("&")) {
                int eq = kv.indexOf(61);
                if (eq == -1) continue;
                query.put(kv.substring(0, eq), kv.substring(eq + 1));
            }
            return query;
        }
        return Collections.emptyMap();
    }

    public SocketAddress socketAddress() {
        return this.socketAddress;
    }

    public String user() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public Integer select() {
        return this.select;
    }

    public boolean ssl() {
        return this.ssl;
    }

    public boolean unix() {
        return this.unix;
    }

    public String param(String key) {
        return this.params.get(key);
    }

    public String userinfo() {
        if (this.user == null && this.password == null) {
            return "";
        }
        return (this.user == null ? "" : this.user) + ":" + (this.password == null ? "" : this.password) + "@";
    }

    public String protocol() {
        if (this.unix) {
            return "unix";
        }
        if (this.ssl) {
            return "rediss";
        }
        return "redis";
    }

    public String toString() {
        return this.protocol() + "://" + this.socketAddress() + "/" + (this.select == null ? "" : this.select);
    }
}

