/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.map.IMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.spi.cluster.hazelcast.ConfigUtil;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastAsyncMap;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastCounter;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastLock;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastNodeInfo;
import io.vertx.spi.cluster.hazelcast.impl.SubsMapHelper;
import io.vertx.spi.cluster.hazelcast.impl.SubsOpSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class HazelcastClusterManager
implements ClusterManager,
MembershipListener,
LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(HazelcastClusterManager.class);
    private static final String LOCK_SEMAPHORE_PREFIX = "__vertx.";
    private VertxInternal vertx;
    private NodeSelector nodeSelector;
    private HazelcastInstance hazelcast;
    private UUID nodeId;
    private NodeInfo nodeInfo;
    private SubsMapHelper subsMapHelper;
    private IMap<String, HazelcastNodeInfo> nodeInfoMap;
    private UUID membershipListenerId;
    private UUID lifecycleListenerId;
    private boolean customHazelcastCluster;
    private Set<String> nodeIds = new HashSet<String>();
    private NodeListener nodeListener;
    private volatile boolean active;
    private Config conf;
    private ExecutorService lockReleaseExec;

    public HazelcastClusterManager() {
    }

    public HazelcastClusterManager(Config conf) {
        Objects.requireNonNull(conf, "The Hazelcast config cannot be null.");
        this.conf = conf;
    }

    public HazelcastClusterManager(HazelcastInstance instance) {
        Objects.requireNonNull(instance, "The Hazelcast instance cannot be null.");
        this.hazelcast = instance;
        this.customHazelcastCluster = true;
    }

    public void init(Vertx vertx, NodeSelector nodeSelector) {
        this.vertx = (VertxInternal)vertx;
        this.nodeSelector = nodeSelector;
    }

    public void join(Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> {
            if (!this.active) {
                this.active = true;
                this.lockReleaseExec = Executors.newCachedThreadPool(r -> new Thread(r, "vertx-hazelcast-service-release-lock-thread"));
                if (!this.customHazelcastCluster) {
                    if (this.conf == null) {
                        this.conf = this.loadConfig();
                        if (this.conf == null) {
                            log.warn((Object)"Cannot find cluster configuration on 'vertx.hazelcast.config' system property, on the classpath, or specified programmatically. Using default hazelcast configuration");
                            this.conf = new Config();
                        }
                    }
                    this.conf.setProperty("hazelcast.shutdownhook.enabled", "false");
                    this.hazelcast = Hazelcast.newHazelcastInstance((Config)this.conf);
                }
                Member localMember = this.hazelcast.getCluster().getLocalMember();
                this.nodeId = localMember.getUuid();
                this.membershipListenerId = this.hazelcast.getCluster().addMembershipListener((MembershipListener)this);
                this.lifecycleListenerId = this.hazelcast.getLifecycleService().addLifecycleListener((LifecycleListener)this);
                this.subsMapHelper = new SubsMapHelper(this.vertx, this.hazelcast, this.nodeSelector);
                this.nodeInfoMap = this.hazelcast.getMap("__vertx.nodeInfo");
                prom.complete();
            }
        }, promise);
    }

    public String getNodeId() {
        return this.nodeId.toString();
    }

    public List<String> getNodes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Member member : this.hazelcast.getCluster().getMembers()) {
            list.add(member.getUuid().toString());
        }
        return list;
    }

    public void nodeListener(NodeListener listener) {
        this.nodeListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeInfo(NodeInfo nodeInfo, Promise<Void> promise) {
        HazelcastClusterManager hazelcastClusterManager = this;
        synchronized (hazelcastClusterManager) {
            this.nodeInfo = nodeInfo;
        }
        HazelcastNodeInfo value = new HazelcastNodeInfo(nodeInfo);
        this.vertx.executeBlocking(prom -> {
            this.nodeInfoMap.put((Object)this.nodeId.toString(), (Object)value);
            prom.complete();
        }, false, promise);
    }

    public synchronized NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void getNodeInfo(String nodeId, Promise<NodeInfo> promise) {
        this.vertx.executeBlocking(prom -> {
            HazelcastNodeInfo value = (HazelcastNodeInfo)this.nodeInfoMap.get((Object)nodeId);
            if (value != null) {
                prom.complete((Object)value.unwrap());
            } else {
                promise.fail("Not a member of the cluster");
            }
        }, false, promise);
    }

    public <K, V> void getAsyncMap(String name, Promise<AsyncMap<K, V>> promise) {
        promise.complete(new HazelcastAsyncMap(this.vertx, this.hazelcast.getMap(name)));
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        return this.hazelcast.getMap(name);
    }

    public void getLockWithTimeout(String name, long timeout, Promise<Lock> promise) {
        this.vertx.executeBlocking(prom -> {
            long start;
            ISemaphore iSemaphore = this.hazelcast.getCPSubsystem().getSemaphore(LOCK_SEMAPHORE_PREFIX + name);
            boolean locked = false;
            long remaining = timeout;
            do {
                start = System.nanoTime();
                try {
                    locked = iSemaphore.tryAcquire(remaining, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!locked && (remaining -= TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS)) > 0L);
            if (!locked) {
                throw new VertxException("Timed out waiting to get lock " + name);
            }
            prom.complete((Object)new HazelcastLock(iSemaphore, this.lockReleaseExec));
        }, false, promise);
    }

    public void getCounter(String name, Promise<Counter> promise) {
        promise.complete((Object)new HazelcastCounter(this.vertx, this.hazelcast.getCPSubsystem().getAtomicLong(name)));
    }

    public void leave(Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> {
            HazelcastClusterManager hazelcastClusterManager = this;
            synchronized (hazelcastClusterManager) {
                if (this.active) {
                    try {
                        this.active = false;
                        this.lockReleaseExec.shutdown();
                        this.subsMapHelper.close();
                        boolean left = this.hazelcast.getCluster().removeMembershipListener(this.membershipListenerId);
                        if (!left) {
                            log.warn((Object)"No membership listener");
                        }
                        this.hazelcast.getLifecycleService().removeLifecycleListener(this.lifecycleListenerId);
                        while (!this.customHazelcastCluster && this.hazelcast.getLifecycleService().isRunning()) {
                            try {
                                this.hazelcast.getLifecycleService().shutdown();
                            }
                            catch (RejectedExecutionException ignore) {
                                log.debug((Object)"Rejected execution of the shutdown operation, retrying");
                            }
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException t) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    catch (Throwable t) {
                        prom.fail(t);
                    }
                }
            }
            prom.complete();
        }, promise);
    }

    public synchronized void memberAdded(MembershipEvent membershipEvent) {
        if (!this.active) {
            return;
        }
        Member member = membershipEvent.getMember();
        String nid = member.getUuid().toString();
        try {
            if (this.nodeListener != null) {
                this.nodeIds.add(nid);
                this.nodeListener.nodeAdded(nid);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to handle memberAdded", t);
        }
    }

    public synchronized void memberRemoved(MembershipEvent membershipEvent) {
        if (!this.active) {
            return;
        }
        Member member = membershipEvent.getMember();
        String nid = member.getUuid().toString();
        try {
            this.membersRemoved(Collections.singleton(nid));
        }
        catch (Throwable t) {
            log.error((Object)"Failed to handle memberRemoved", t);
        }
    }

    private synchronized void membersRemoved(Set<String> ids) {
        this.cleanSubs(ids);
        this.cleanNodeInfos(ids);
        this.nodeInfoMap.put((Object)this.nodeId.toString(), (Object)new HazelcastNodeInfo(this.getNodeInfo()));
        this.nodeSelector.registrationsLost();
        this.republishOwnSubs();
        if (this.nodeListener != null) {
            this.nodeIds.removeAll(ids);
            ids.forEach(arg_0 -> ((NodeListener)this.nodeListener).nodeLeft(arg_0));
        }
    }

    private void cleanSubs(Set<String> ids) {
        this.subsMapHelper.removeAllForNodes(ids);
    }

    private void cleanNodeInfos(Set<String> ids) {
        ids.forEach(arg_0 -> this.nodeInfoMap.remove(arg_0));
    }

    private void republishOwnSubs() {
        this.vertx.executeBlocking(prom -> {
            this.subsMapHelper.republishOwnSubs();
            prom.complete();
        }, false);
    }

    public synchronized void stateChanged(LifecycleEvent lifecycleEvent) {
        if (!this.active) {
            return;
        }
        if (lifecycleEvent.getState() == LifecycleEvent.LifecycleState.MERGED) {
            List<String> currentNodes = this.getNodes();
            HashSet<String> newNodes = new HashSet<String>(currentNodes);
            newNodes.removeAll(this.nodeIds);
            HashSet<String> removedMembers = new HashSet<String>(this.nodeIds);
            removedMembers.removeAll(currentNodes);
            if (this.nodeListener != null) {
                for (String nodeId : newNodes) {
                    this.nodeListener.nodeAdded(nodeId);
                }
            }
            this.membersRemoved(removedMembers);
            this.nodeIds.retainAll(currentNodes);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void addRegistration(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        SubsOpSerializer serializer = SubsOpSerializer.get(this.vertx.getOrCreateContext());
        serializer.execute(this.subsMapHelper::put, address, registrationInfo, promise);
    }

    public void removeRegistration(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        SubsOpSerializer serializer = SubsOpSerializer.get(this.vertx.getOrCreateContext());
        serializer.execute(this.subsMapHelper::remove, address, registrationInfo, promise);
    }

    public void getRegistrations(String address, Promise<List<RegistrationInfo>> promise) {
        this.vertx.executeBlocking(prom -> prom.complete(this.subsMapHelper.get(address)), false, promise);
    }

    public String clusterHost() {
        String host;
        if (!this.customHazelcastCluster && (host = System.getProperty("hazelcast.local.localAddress")) != null) {
            return host;
        }
        if (!this.customHazelcastCluster && this.conf.getNetworkConfig().getPublicAddress() == null) {
            return this.hazelcast.getCluster().getLocalMember().getAddress().getHost();
        }
        return null;
    }

    public String clusterPublicHost() {
        String host;
        if (!this.customHazelcastCluster && (host = System.getProperty("hazelcast.local.publicAddress")) != null) {
            return host;
        }
        if (!this.customHazelcastCluster && (host = this.conf.getNetworkConfig().getPublicAddress()) != null) {
            return host;
        }
        return null;
    }

    public Config getConfig() {
        return this.conf;
    }

    public void setConfig(Config config) {
        this.conf = config;
    }

    public Config loadConfig() {
        return ConfigUtil.loadConfig();
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcast;
    }
}

