/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.docgen;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import io.vertx.docgen.DocGenerator;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

public class JavaDocGenerator
implements DocGenerator {
    protected DocTrees docTrees;
    protected ProcessingEnvironment processingEnv;
    private static final Pattern A = Pattern.compile("^\\(@[^ ]+ :: ([^\\\\]+)\\)$");

    @Override
    public void init(ProcessingEnvironment env) {
        this.docTrees = DocTrees.instance(env);
        this.processingEnv = env;
    }

    @Override
    public String getName() {
        return "java";
    }

    @Override
    public String resolveTypeLink(TypeElement elt) {
        return "../../apidocs/" + elt.getQualifiedName().toString().replace('.', '/') + ".html";
    }

    @Override
    public String resolveConstructorLink(ExecutableElement elt) {
        return this.toExecutableLink(elt, elt.getEnclosingElement().getSimpleName().toString());
    }

    @Override
    public String resolveMethodLink(ExecutableElement elt) {
        return this.toExecutableLink(elt, elt.getSimpleName().toString());
    }

    @Override
    public String resolveLabel(Element elt, String defaultLabel) {
        return defaultLabel;
    }

    private String toExecutableLink(ExecutableElement elt, String name) {
        TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
        String link = this.resolveTypeLink(typeElt);
        StringBuilder anchor = new StringBuilder("#");
        anchor.append(name).append('-');
        TypeMirror type = elt.asType();
        ExecutableType methodType = (ExecutableType)this.processingEnv.getTypeUtils().erasure(type);
        List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            TypeMirror typeOfParameter;
            String s;
            Matcher matcher;
            if (i > 0) {
                anchor.append('-');
            }
            if ((matcher = A.matcher(s = (typeOfParameter = parameterTypes.get(i)).toString())).matches()) {
                String t = matcher.group(1);
                anchor.append(t);
                continue;
            }
            anchor.append(s);
        }
        anchor.append('-');
        return link + anchor;
    }

    @Override
    public String resolveFieldLink(VariableElement elt) {
        TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
        String link = this.resolveTypeLink(typeElt);
        return link + "#" + elt.getSimpleName();
    }

    @Override
    public String renderSource(ExecutableElement elt, String source) {
        TreePath path = this.docTrees.getPath(elt);
        MethodTree methodTree = (MethodTree)path.getLeaf();
        BlockTree blockTree = methodTree.getBody();
        List<? extends StatementTree> statements = blockTree.getStatements();
        if (statements.size() > 0) {
            return this.renderSource(path, statements, source);
        }
        return null;
    }

    public String renderSource(TypeElement elt, String source) {
        TreePath path = this.docTrees.getPath(elt);
        ClassTree classTree = (ClassTree)path.getLeaf();
        return this.renderSource(path, Collections.singletonList(classTree), source);
    }

    public String renderSource(TreePath path, List<? extends Tree> trees, String source) {
        int from;
        CompilationUnitTree unit = path.getCompilationUnit();
        int to = (int)this.docTrees.getSourcePositions().getEndPosition(unit, trees.get(trees.size() - 1));
        for (from = (int)this.docTrees.getSourcePositions().getStartPosition(unit, trees.get(0)); from > 1 && source.charAt(from - 1) != '\n'; --from) {
        }
        while (to < source.length() && source.charAt(to) != '\n') {
            ++to;
        }
        String block = source.substring(from, to);
        int blockMargin = Integer.MAX_VALUE;
        LineMap lineMap = unit.getLineMap();
        for (Tree tree : trees) {
            int statementStart;
            int lineStart = statementStart = (int)this.docTrees.getSourcePositions().getStartPosition(unit, tree);
            while (lineMap.getLineNumber(statementStart) == lineMap.getLineNumber(lineStart - 1)) {
                --lineStart;
            }
            blockMargin = Math.min(blockMargin, statementStart - lineStart);
        }
        StringBuilder fragment = new StringBuilder();
        Scanner scanner = new Scanner(block).useDelimiter("\n");
        while (scanner.hasNext()) {
            String line = (String)scanner.next();
            int margin = Math.min(blockMargin, line.length());
            line = line.substring(margin);
            fragment.append(line);
            if (!scanner.hasNext()) continue;
            fragment.append('\n');
        }
        return fragment.toString();
    }
}

