/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.stack.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.stack.resolver.ResolutionOptions;
import io.vertx.stack.utils.Home;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.artifact.DefaultArtifact;

public class Cache {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"stack-manager-cache");
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new SimpleModule("artifact-module").addDeserializer(Artifact.class, (JsonDeserializer)new JsonDeserializer<Artifact>(){

        public Artifact deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            Artifact artifact = node.get("classifier") != null ? new DefaultArtifact(node.get("groupId").asText(), node.get("artifactId").asText(), node.get("classifier").asText(), node.get("extension").asText(), node.get("version").asText()) : new DefaultArtifact(node.get("groupId").asText(), node.get("artifactId").asText(), node.get("extension").asText(), node.get("version").asText());
            artifact = artifact.setFile(new File(node.get("file").asText()));
            return artifact;
        }
    }));
    private final boolean disabled;
    private final boolean disabledForSnapshot;
    List<CacheEntry> cache = new ArrayList<CacheEntry>();
    private File cacheFile;

    public Cache(boolean disabled, boolean disabledForSnapshot, File cacheFile) {
        this.disabled = disabled;
        this.disabledForSnapshot = disabledForSnapshot;
        this.cacheFile = cacheFile;
        if (this.cacheFile == null && Home.getVertxHome() != null) {
            this.cacheFile = new File(Home.getVertxHome(), ".stack-manager-cache.json");
            LOGGER.info((Object)("Set resolver cache to " + this.cacheFile.getAbsolutePath()));
        }
        if (this.cacheFile != null && !this.cacheFile.isFile()) {
            this.cacheFile.getParentFile().mkdirs();
        }
        if (!disabled && this.cacheFile != null && this.cacheFile.isFile()) {
            LOGGER.info((Object)("Loading resolver cache from " + this.cacheFile.getAbsolutePath()));
            CollectionType type = MAPPER.getTypeFactory().constructCollectionType(List.class, CacheEntry.class);
            try {
                this.cache.addAll((Collection)MAPPER.readValue(this.cacheFile, (JavaType)type));
            }
            catch (IOException e) {
                LOGGER.error((Object)("Cannot read the cache entries from " + this.cacheFile.getAbsolutePath() + ": " + e.getMessage()));
            }
        }
    }

    public void writeCacheOnFile() {
        if (this.disabled) {
            return;
        }
        if (this.cacheFile != null) {
            try {
                MAPPER.writer().writeValue(this.cacheFile, this.cache);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Cannot write the cache entries to " + this.cacheFile.getAbsolutePath() + ": " + e.getMessage()));
            }
        }
    }

    public List<Artifact> get(String gacv, ResolutionOptions resolutionOptions) {
        if (this.disabled) {
            return null;
        }
        if (this.disabledForSnapshot && gacv.contains("SNAPSHOT")) {
            return null;
        }
        Optional<CacheEntry> entry = this.find(gacv, resolutionOptions);
        if (entry.isPresent()) {
            if (this.isValid(entry.get())) {
                return entry.get().getArtifacts();
            }
            this.cache.remove(entry.get());
            return null;
        }
        return null;
    }

    private boolean isValid(CacheEntry entry) {
        if (entry.getArtifacts().isEmpty()) {
            return false;
        }
        if (entry.getArtifacts().stream().filter(artifact -> !artifact.getFile().isFile()).findAny().isPresent()) {
            return false;
        }
        if (entry.gacv.contains("SNAPSHOT")) {
            long insertion;
            long now = System.currentTimeMillis();
            return now - (insertion = entry.getInsertionTime()) < 86400000L;
        }
        return true;
    }

    public void put(String gacv, ResolutionOptions resolutionOptions, List<Artifact> list) {
        if (this.disabled) {
            return;
        }
        if (this.disabledForSnapshot && gacv.contains("SNAPSHOT")) {
            return;
        }
        Optional<CacheEntry> entry = this.find(gacv, resolutionOptions);
        if (entry.isPresent()) {
            CacheEntry cached = entry.get();
            cached.setInsertionTime(System.currentTimeMillis()).setArtifacts(list);
        } else {
            CacheEntry cached = new CacheEntry();
            cached.setArtifacts(list).setGacv(gacv).setOptions(resolutionOptions).setInsertionTime(System.currentTimeMillis());
            this.cache.add(cached);
        }
    }

    public Optional<CacheEntry> find(String gacv, ResolutionOptions options) {
        return this.cache.stream().filter(entry -> entry.gacv.equals(gacv) && entry.options.equals(options)).findFirst();
    }

    public int size() {
        return this.cache.size();
    }

    public static class CacheEntry {
        String gacv;
        ResolutionOptions options;
        List<Artifact> artifacts = new ArrayList<Artifact>();
        long insertionTime;

        public List<Artifact> getArtifacts() {
            return this.artifacts;
        }

        public CacheEntry setArtifacts(List<Artifact> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public String getGacv() {
            return this.gacv;
        }

        public CacheEntry setGacv(String gacv) {
            this.gacv = gacv;
            return this;
        }

        public long getInsertionTime() {
            return this.insertionTime;
        }

        public CacheEntry setInsertionTime(long insertionTime) {
            this.insertionTime = insertionTime;
            return this;
        }

        public ResolutionOptions getOptions() {
            return this.options;
        }

        public CacheEntry setOptions(ResolutionOptions options) {
            this.options = options;
            return this;
        }
    }
}

