/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.JksOptions;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;

public class SSLKeyPairCerts {
    private static final String SERVER_CERT_SUBJECT = "CN=Vertx Server, OU=Middleware Runtime, O=Red Hat, C=US";
    private static final String CLIENT_CERT_SUBJECT = "CN=Vertx Client, OU=Middleware Runtime, O=Red Hat, C=US";
    private static final String PASSWORD = "wibble";
    private JksOptions serverKeyStore;
    private JksOptions serverTrustStore;
    private JksOptions clientKeyStore;
    private JksOptions clientTrustStore;

    public SSLKeyPairCerts createTwoWaySSL() {
        try {
            KeyPair serverRSAKeyPair = this.generateRSAKeyPair(2048);
            X509Certificate serverCert = this.generateSelfSignedCert(SERVER_CERT_SUBJECT, serverRSAKeyPair);
            KeyPair clientRSAKeyPair = this.generateRSAKeyPair(2048);
            X509Certificate clientCert = this.generateSelfSignedCert(CLIENT_CERT_SUBJECT, clientRSAKeyPair);
            KeyStore serverKeyStore = this.emptyJKSStore(PASSWORD);
            serverKeyStore.setKeyEntry("localserver", serverRSAKeyPair.getPrivate(), PASSWORD.toCharArray(), new Certificate[]{serverCert});
            KeyStore serverTrustStore = this.emptyJKSStore(PASSWORD);
            serverTrustStore.setCertificateEntry("clientcert", clientCert);
            KeyStore clientKeyStore = this.emptyJKSStore(PASSWORD);
            clientKeyStore.setKeyEntry("localclient", clientRSAKeyPair.getPrivate(), PASSWORD.toCharArray(), new Certificate[]{clientCert});
            KeyStore clientTrustStore = this.emptyJKSStore(PASSWORD);
            clientTrustStore.setCertificateEntry("servercert", serverCert);
            ByteArrayOutputStream serverKeyStoreOutputStream = new ByteArrayOutputStream(512);
            serverKeyStore.store(serverKeyStoreOutputStream, PASSWORD.toCharArray());
            this.serverKeyStore = new JksOptions().setPassword(PASSWORD).setValue(Buffer.buffer((byte[])serverKeyStoreOutputStream.toByteArray()));
            ByteArrayOutputStream serverTrustStoreOutputStream = new ByteArrayOutputStream(512);
            serverTrustStore.store(serverTrustStoreOutputStream, PASSWORD.toCharArray());
            this.serverTrustStore = new JksOptions().setPassword(PASSWORD).setValue(Buffer.buffer((byte[])serverTrustStoreOutputStream.toByteArray()));
            ByteArrayOutputStream clientKeyStoreOutputStream = new ByteArrayOutputStream(512);
            clientKeyStore.store(clientKeyStoreOutputStream, PASSWORD.toCharArray());
            this.clientKeyStore = new JksOptions().setPassword(PASSWORD).setValue(Buffer.buffer((byte[])clientKeyStoreOutputStream.toByteArray()));
            ByteArrayOutputStream clientTrustStoreOutputStream = new ByteArrayOutputStream(512);
            clientTrustStore.store(clientTrustStoreOutputStream, PASSWORD.toCharArray());
            this.clientTrustStore = new JksOptions().setPassword(PASSWORD).setValue(Buffer.buffer((byte[])clientTrustStoreOutputStream.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot generate SSL key pairs and certificates", e);
        }
        return this;
    }

    private X509Certificate generateSelfSignedCert(String certSub, KeyPair keyPair) throws Exception {
        X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(new X500Name(certSub), BigInteger.ONE, new Date(System.currentTimeMillis() - 2592000000L), new Date(System.currentTimeMillis() + 2592000000L), new X500Name(certSub), SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
        GeneralNames subjectAltNames = new GeneralNames(new GeneralName(7, "127.0.0.1"));
        certificateBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA1WithRSAEncryption");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        BcRSAContentSignerBuilder signerBuilder = new BcRSAContentSignerBuilder(sigAlgId, digAlgId);
        AsymmetricKeyParameter keyp = PrivateKeyFactory.createKey((byte[])keyPair.getPrivate().getEncoded());
        ContentSigner signer = signerBuilder.build(keyp);
        X509CertificateHolder x509CertificateHolder = certificateBuilder.build(signer);
        X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
        certificate.checkValidity(new Date());
        certificate.verify(keyPair.getPublic());
        return certificate;
    }

    private KeyPair generateRSAKeyPair(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.genKeyPair();
    }

    private KeyStore emptyJKSStore(String password) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, password.toCharArray());
        return ks;
    }

    public JksOptions getServerKeyStore() {
        return this.serverKeyStore;
    }

    public JksOptions getServerTrustStore() {
        return this.serverTrustStore;
    }

    public JksOptions getClientKeyStore() {
        return this.clientKeyStore;
    }

    public JksOptions getClientTrustStore() {
        return this.clientTrustStore;
    }
}

