/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp;

import io.vertx.core.Vertx;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.eventbus.bridge.tcp.SSLKeyPairCerts;
import io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameHelper;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class TcpEventBusBridgeEventTest {
    private static final Logger logger = LoggerFactory.getLogger(TcpEventBusBridgeEventTest.class);
    private Vertx vertx;
    private SSLKeyPairCerts sslKeyPairCerts;

    @Before
    public void before(TestContext context) {
        this.vertx = Vertx.vertx();
        Async async = context.async();
        this.vertx.eventBus().consumer("hello", msg -> msg.reply((Object)new JsonObject().put("value", (Object)("Hello " + ((JsonObject)msg.body()).getString("value")))));
        this.vertx.eventBus().consumer("echo", msg -> msg.reply(msg.body()));
        this.vertx.setPeriodic(1000L, __ -> this.vertx.eventBus().send("ping", (Object)new JsonObject().put("value", (Object)"hi")));
        this.sslKeyPairCerts = new SSLKeyPairCerts().createTwoWaySSL();
        TcpEventBusBridge bridge = TcpEventBusBridge.create((Vertx)this.vertx, (BridgeOptions)new BridgeOptions().addInboundPermitted(new PermittedOptions().setAddress("hello")).addInboundPermitted(new PermittedOptions().setAddress("echo")).addInboundPermitted(new PermittedOptions().setAddress("test")).addOutboundPermitted(new PermittedOptions().setAddress("echo")).addOutboundPermitted(new PermittedOptions().setAddress("ping")), (NetServerOptions)new NetServerOptions().setClientAuth(ClientAuth.REQUEST).setSsl(true).setTrustStoreOptions(this.sslKeyPairCerts.getServerTrustStore()).setKeyStoreOptions(this.sslKeyPairCerts.getServerKeyStore()), be -> {
            logger.info((Object)("Handled a bridge event " + be.getRawMessage()));
            if (be.socket().isSsl()) {
                try {
                    for (X509Certificate c : be.socket().peerCertificateChain()) {
                        logger.info((Object)c.getSubjectDN().toString());
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    throw new RuntimeException("Failed to get peer certificates chain", e);
                }
            }
            be.complete((Object)true);
        });
        bridge.listen(7000, res -> {
            context.assertTrue(res.succeeded());
            async.complete();
        });
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    @Test
    public void testSendVoidMessage(TestContext context) {
        NetClient client = this.vertx.createNetClient(new NetClientOptions().setSsl(true).setTrustStoreOptions(this.sslKeyPairCerts.getClientTrustStore()).setKeyStoreOptions(this.sslKeyPairCerts.getClientKeyStore()));
        Async async = context.async();
        this.vertx.eventBus().consumer("test", msg -> {
            client.close();
            async.complete();
        });
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameHelper.sendFrame((String)"send", (String)"test", (JsonObject)new JsonObject().put("value", (Object)"vert.x"), (WriteStream)socket);
        });
    }

    @Test
    public void testSendVoidMessageTrustAll(TestContext context) {
        NetClient client = this.vertx.createNetClient(new NetClientOptions().setSsl(true).setTrustAll(true).setKeyStoreOptions(this.sslKeyPairCerts.getClientKeyStore()));
        Async async = context.async();
        this.vertx.eventBus().consumer("test", msg -> {
            client.close();
            async.complete();
        });
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameHelper.sendFrame((String)"send", (String)"test", (JsonObject)new JsonObject().put("value", (Object)"vert.x"), (WriteStream)socket);
        });
    }
}

