/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameHelper;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameParser;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class TcpEventBusBridgeHookTest {
    private final String address = "hello";
    private Vertx vertx;

    @Before
    public void before(TestContext context) {
        this.vertx = Vertx.vertx();
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    @Test
    public void testRegister(TestContext context) {
        JsonObject payload = new JsonObject().put("value", (Object)"Francesco");
        Async bridgeStart = context.async();
        Async register = context.async();
        Async registered = context.async();
        Async request = context.async();
        TcpEventBusBridge bridge = TcpEventBusBridge.create((Vertx)this.vertx, (BridgeOptions)new BridgeOptions().addInboundPermitted(new PermittedOptions()).addOutboundPermitted(new PermittedOptions()), (NetServerOptions)new NetServerOptions(), be -> {
            if (be.type() == BridgeEventType.REGISTER) {
                context.assertNotNull((Object)be.socket());
                context.assertEquals((Object)"hello", (Object)be.getRawMessage().getString("address"));
                register.complete();
            } else if (be.type() == BridgeEventType.REGISTERED) {
                context.assertNotNull((Object)be.socket());
                context.assertEquals((Object)"hello", (Object)be.getRawMessage().getString("address"));
                this.vertx.eventBus().send("hello", (Object)payload);
                registered.complete();
            }
            be.complete((Object)true);
        });
        bridge.listen(7000, res -> {
            context.assertTrue(res.succeeded());
            bridgeStart.complete();
        });
        bridgeStart.await();
        NetClient client = this.vertx.createNetClient();
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameParser parser = new FrameParser(parse -> {
                context.assertTrue(parse.succeeded());
                JsonObject frame = (JsonObject)parse.result();
                context.assertNotEquals((Object)"err", (Object)frame.getString("type"));
                context.assertEquals((Object)"Francesco", (Object)frame.getJsonObject("body").getString("value"));
                client.close();
                request.complete();
            });
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"register", (String)"hello", null, (WriteStream)socket);
        });
        register.await();
        registered.await();
        request.await();
    }
}

