/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameHelper;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameParser;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class TcpEventBusBridgeInteropTest {
    private Vertx vertx;

    @Before
    public void before(TestContext context) {
        this.vertx = Vertx.vertx();
        Async async = context.async();
        this.vertx.eventBus().consumer("hello", msg -> msg.reply((Object)new JsonObject().put("value", (Object)("Hello " + ((JsonObject)msg.body()).getString("value")))));
        TcpEventBusBridge bridge = TcpEventBusBridge.create((Vertx)this.vertx, (BridgeOptions)new BridgeOptions().addInboundPermitted(new PermittedOptions()).addOutboundPermitted(new PermittedOptions()));
        bridge.listen(7000, res -> {
            context.assertTrue(res.succeeded());
            async.complete();
        });
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    @Test
    public void testInteropWithPlainJava(TestContext context) {
        Async async = context.async();
        EventBus eb = this.vertx.eventBus();
        eb.consumer("io.vertx", msg -> {
            context.assertEquals((Object)"findAll", (Object)msg.headers().get("action"));
            context.assertNotNull(msg.body());
            msg.reply(msg.body());
        });
        this.vertx.executeBlocking(f -> {
            try {
                JsonObject headers = new JsonObject();
                headers.put("action", (Object)"findAll");
                JsonObject body = new JsonObject();
                body.put("model", (Object)"news");
                JsonObject protocol = new JsonObject();
                protocol.put("type", (Object)"send");
                protocol.put("headers", (Object)headers);
                protocol.put("body", (Object)body);
                protocol.put("address", (Object)"io.vertx");
                protocol.put("replyAddress", (Object)"durp");
                Buffer buffer = Buffer.buffer();
                buffer.appendInt(protocol.encode().getBytes().length);
                buffer.appendString(protocol.encode());
                Socket clientSocket = new Socket("localhost", 7000);
                DataOutputStream output = new DataOutputStream(clientSocket.getOutputStream());
                output.write(buffer.getBytes());
                DataInputStream input = new DataInputStream(clientSocket.getInputStream());
                int bytesLength = input.readInt();
                byte[] bytes = new byte[bytesLength];
                for (int i = 0; i < bytesLength; ++i) {
                    bytes[i] = input.readByte();
                }
                input.close();
                output.close();
                clientSocket.close();
                JsonObject reply = new JsonObject(new String(bytes));
                context.assertEquals((Object)body, (Object)reply.getJsonObject("body"));
                f.complete();
            }
            catch (IOException e) {
                f.fail((Throwable)e);
            }
        }, res -> {
            context.assertTrue(res.succeeded());
            async.complete();
        });
    }

    @Test
    public void testSendMessageWithReplyBacktrack(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameParser parser = new FrameParser(parse -> {
                context.assertTrue(parse.succeeded());
                JsonObject frame = (JsonObject)parse.result();
                context.assertNotEquals((Object)"err", (Object)frame.getString("type"));
                context.assertEquals((Object)"Hello vert.x", (Object)frame.getJsonObject("body").getString("value"));
                client.close();
                async.complete();
            });
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"send", (String)"hello", (String)"#backtrack", (JsonObject)new JsonObject().put("value", (Object)"vert.x"), (WriteStream)socket);
        });
    }

    @Test
    public void testSendMessageWithDuplicateReplyID(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            this.vertx.eventBus().consumer("third-party-receiver", msg -> context.fail());
            FrameParser parser = new FrameParser(parse -> {
                context.assertTrue(parse.succeeded());
                client.close();
                async.complete();
            });
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"send", (String)"hello", (String)"third-party-receiver", (JsonObject)new JsonObject().put("value", (Object)"vert.x"), (WriteStream)socket);
        });
    }

    @Test
    public void testRegister(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameParser parser = new FrameParser(parse -> {
                context.assertTrue(parse.succeeded());
                JsonObject frame = (JsonObject)parse.result();
                context.assertNotEquals((Object)"err", (Object)frame.getString("type"));
                context.assertEquals((Object)"Vert.x", (Object)frame.getJsonObject("body").getString("value"));
                client.close();
                async.complete();
            });
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"register", (String)"echo", null, (WriteStream)socket);
            FrameHelper.sendFrame((String)"publish", (String)"echo", (JsonObject)new JsonObject().put("value", (Object)"Vert.x"), (WriteStream)socket);
        });
    }
}

