/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.ext.web.openapi.impl.AnyOfOneOfSingleParameterParser;
import io.vertx.ext.web.openapi.impl.ContainerSerializationStyles;
import io.vertx.ext.web.openapi.impl.FlagParameterParser;
import io.vertx.ext.web.openapi.impl.GeneratorContext;
import io.vertx.ext.web.openapi.impl.OpenAPI3Utils;
import io.vertx.ext.web.openapi.impl.ParameterProcessorGenerator;
import io.vertx.ext.web.openapi.impl.SchemaHolder;
import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.ValueParserInferenceUtils;
import io.vertx.ext.web.validation.impl.parameter.ParameterParser;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessor;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessorImpl;
import io.vertx.ext.web.validation.impl.parameter.SingleValueParameterParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.impl.validator.ValueValidator;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultParameterProcessorGenerator
implements ParameterProcessorGenerator {
    @Override
    public boolean canGenerate(JsonObject parameter, JsonObject fakeSchema, ParameterLocation parsedLocation, String parsedStyle) {
        return !parameter.containsKey("content");
    }

    @Override
    public ParameterProcessor generate(JsonObject parameter, JsonObject fakeSchema, JsonPointer parameterPointer, ParameterLocation parsedLocation, String parsedStyle, GeneratorContext context) {
        SchemaHolder schemas = context.getSchemaHolder(parameter.getJsonObject("schema", new JsonObject()), fakeSchema, parameterPointer.copy().append("schema"));
        if (parsedLocation == ParameterLocation.QUERY && parameter.getBoolean("allowEmptyValue", Boolean.valueOf(false)).booleanValue() && "boolean".equals(fakeSchema.getString("type"))) {
            return new ParameterProcessorImpl(parameter.getString("name"), parsedLocation, parameter.getBoolean("required", Boolean.valueOf(false)) == false, (ParameterParser)new FlagParameterParser(parameter.getString("name")), (ValueValidator)schemas.getValidator());
        }
        if (OpenAPI3Utils.isFakeSchemaAnyOfOrOneOf(fakeSchema)) {
            List<ValueParser<String>> valueParsers = fakeSchema.getJsonArray("x-anyOf", fakeSchema.getJsonArray("x-oneOf")).stream().map(j -> (JsonObject)j).map(j -> this.generateValueParser((JsonObject)j, parsedStyle)).collect(Collectors.toList());
            return new ParameterProcessorImpl(parameter.getString("name"), parsedLocation, parameter.getBoolean("required", Boolean.valueOf(false)) == false, (ParameterParser)new AnyOfOneOfSingleParameterParser(parsedLocation.lowerCaseIfNeeded(parameter.getString("name")), valueParsers), (ValueValidator)schemas.getValidator());
        }
        ValueParser<String> valueParser = this.generateValueParser(fakeSchema, parsedStyle);
        return new ParameterProcessorImpl(parameter.getString("name"), parsedLocation, parameter.getBoolean("required", Boolean.valueOf(false)) == false, (ParameterParser)new SingleValueParameterParser(parsedLocation.lowerCaseIfNeeded(parameter.getString("name")), valueParser), (ValueValidator)schemas.getValidator());
    }

    private ValueParser<String> generateValueParserForObjectParameter(JsonObject fakeSchema, String parsedStyle) {
        return ContainerSerializationStyles.resolve(parsedStyle).getObjectFactory().newObjectParser(ValueParserInferenceUtils.infeerPropertiesParsersForObjectSchema((Object)fakeSchema), ValueParserInferenceUtils.infeerPatternPropertiesParsersForObjectSchema((Object)fakeSchema), ValueParserInferenceUtils.infeerAdditionalPropertiesParserForObjectSchema((Object)fakeSchema));
    }

    private ValueParser<String> generateForArrayParameter(JsonObject fakeSchema, String parsedStyle) {
        return ContainerSerializationStyles.resolve(parsedStyle).getArrayFactory().newArrayParser(ValueParserInferenceUtils.infeerItemsParserForArraySchema((Object)fakeSchema));
    }

    private ValueParser<String> generateForPrimitiveParameter(JsonObject fakeSchema) {
        return ValueParserInferenceUtils.infeerPrimitiveParser((Object)fakeSchema);
    }

    private ValueParser<String> generateValueParser(JsonObject fakeSchema, String parsedStyle) {
        if (OpenAPI3Utils.isSchemaObjectOrCombinators(fakeSchema)) {
            return this.generateValueParserForObjectParameter(fakeSchema, parsedStyle);
        }
        if (OpenAPI3Utils.isSchemaArray(fakeSchema)) {
            return this.generateForArrayParameter(fakeSchema, parsedStyle);
        }
        return this.generateForPrimitiveParameter(fakeSchema);
    }
}

