/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.ext.web.openapi.impl.GeneratorContext;
import io.vertx.ext.web.openapi.impl.OpenAPI3Utils;
import io.vertx.ext.web.openapi.impl.ParameterProcessorGenerator;
import io.vertx.ext.web.openapi.impl.SchemaHolder;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.ValueParserInferenceUtils;
import io.vertx.ext.web.validation.impl.parameter.ParameterParser;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessor;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessorImpl;
import io.vertx.ext.web.validation.impl.parameter.SingleValueParameterParser;
import io.vertx.ext.web.validation.impl.parser.ArrayParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.impl.validator.ValueValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ExplodedMatrixArrayParameterProcessorGenerator
implements ParameterProcessorGenerator {
    @Override
    public boolean canGenerate(JsonObject parameter, JsonObject fakeSchema, ParameterLocation parsedLocation, String parsedStyle) {
        return parsedStyle.equals("matrix") && OpenAPI3Utils.resolveExplode(parameter) && OpenAPI3Utils.isSchemaArray(fakeSchema);
    }

    @Override
    public ParameterProcessor generate(JsonObject parameter, JsonObject fakeSchema, JsonPointer parameterPointer, ParameterLocation parsedLocation, String parsedStyle, GeneratorContext context) {
        SchemaHolder schemas = context.getSchemaHolder(parameter.getJsonObject("schema", new JsonObject()), fakeSchema, parameterPointer.copy().append("schema"));
        return new ParameterProcessorImpl(parameter.getString("name"), parsedLocation, parameter.getBoolean("required", Boolean.valueOf(false)) == false, (ParameterParser)new SingleValueParameterParser(parsedLocation.lowerCaseIfNeeded(parameter.getString("name")), (ValueParser)new ExplodedMatrixArrayValueParser((ValueParser<String>)ValueParserInferenceUtils.infeerItemsParserForArraySchema((Object)schemas.getFakeSchema()))), (ValueValidator)schemas.getValidator());
    }

    private static class ExplodedMatrixArrayValueParser
    extends ArrayParser
    implements ValueParser<String> {
        private final Pattern MATRIX_PARAMETER = Pattern.compile(";(?<key>[^;=]*)=(?<value>[^\\/\\;\\?\\:\\@\\&\\\"\\<\\>\\#\\%\\{\\}\\|\\\\\\^\\~\\[\\]\\`]*)");

        public ExplodedMatrixArrayValueParser(ValueParser<String> itemsParser) {
            super(itemsParser);
        }

        protected boolean mustNullateValue(String serialized) {
            return serialized == null || serialized.isEmpty() && this.itemsParser != ValueParser.NOOP_PARSER;
        }

        public @Nullable JsonArray parse(String serialized) throws MalformedValueException {
            return this.deserializeArray(serialized).map(arg_0 -> ((ExplodedMatrixArrayValueParser)this).parseValue(arg_0)).reduce(new JsonArray(), JsonArray::add, JsonArray::addAll);
        }

        private Stream<String> deserializeArray(String serialized) throws MalformedValueException {
            Stream.Builder<String> values = Stream.builder();
            Matcher m = this.MATRIX_PARAMETER.matcher(serialized);
            while (m.find()) {
                values.add(URIDecoder.decodeURIComponent((String)m.group("value"), (boolean)false));
            }
            return values.build();
        }
    }
}

