/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.ext.web.openapi.impl.GeneratorContext;
import io.vertx.ext.web.openapi.impl.OpenAPI3Utils;
import io.vertx.ext.web.openapi.impl.ParameterProcessorGenerator;
import io.vertx.ext.web.openapi.impl.SchemaHolder;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.ValueParserInferenceUtils;
import io.vertx.ext.web.validation.impl.parameter.ParameterParser;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessor;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessorImpl;
import io.vertx.ext.web.validation.impl.parameter.SingleValueParameterParser;
import io.vertx.ext.web.validation.impl.parser.ObjectParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.impl.validator.ValueValidator;
import java.util.Map;
import java.util.regex.Pattern;

public class ExplodedSimpleObjectParameterProcessorGenerator
implements ParameterProcessorGenerator {
    @Override
    public boolean canGenerate(JsonObject parameter, JsonObject fakeSchema, ParameterLocation parsedLocation, String parsedStyle) {
        return parsedStyle.equals("simple") && OpenAPI3Utils.resolveExplode(parameter) && OpenAPI3Utils.isSchemaObjectOrCombinators(fakeSchema);
    }

    @Override
    public ParameterProcessor generate(JsonObject parameter, JsonObject fakeSchema, JsonPointer parameterPointer, ParameterLocation parsedLocation, String parsedStyle, GeneratorContext context) {
        SchemaHolder schemas = context.getSchemaHolder(parameter.getJsonObject("schema", new JsonObject()), fakeSchema, parameterPointer.copy().append("schema"));
        return new ParameterProcessorImpl(parameter.getString("name"), parsedLocation, parameter.getBoolean("required", Boolean.valueOf(false)) == false, (ParameterParser)new SingleValueParameterParser(parameter.getString("name"), (ValueParser)new ExplodedSimpleObjectValueParser(ValueParserInferenceUtils.infeerPropertiesParsersForObjectSchema((Object)schemas.getFakeSchema()), ValueParserInferenceUtils.infeerPatternPropertiesParsersForObjectSchema((Object)schemas.getFakeSchema()), (ValueParser<String>)ValueParserInferenceUtils.infeerAdditionalPropertiesParserForObjectSchema((Object)schemas.getFakeSchema()))), (ValueValidator)schemas.getValidator());
    }

    private static class ExplodedSimpleObjectValueParser
    extends ObjectParser<String>
    implements ValueParser<String> {
        public ExplodedSimpleObjectValueParser(Map<String, ValueParser<String>> propertiesParsers, Map<Pattern, ValueParser<String>> patternPropertiesParsers, ValueParser<String> additionalPropertiesParser) {
            super(propertiesParsers, patternPropertiesParsers, additionalPropertiesParser);
        }

        protected ValueParser<String> getAdditionalPropertiesParserIfRequired() {
            return this.additionalPropertiesParser;
        }

        protected boolean mustNullateValue(String serialized, ValueParser<String> parser) {
            return serialized == null || serialized.isEmpty() && parser != ValueParser.NOOP_PARSER;
        }

        public @Nullable Object parse(String serialized) throws MalformedValueException {
            String[] values;
            JsonObject result = new JsonObject();
            for (String value : values = serialized.split(Pattern.quote(","), -1)) {
                String[] values_internal = value.split("=", -1);
                if (values_internal[0].length() == 0) {
                    throw new MalformedValueException("Empty key not allowed");
                }
                Map.Entry parsedEntry = this.parseField(values_internal[0], values_internal[1]);
                if (parsedEntry == null) continue;
                result.put((String)parsedEntry.getKey(), parsedEntry.getValue());
            }
            return result;
        }
    }
}

