/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.core.json.pointer.JsonPointerIterator;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.openapi.RouterBuilderException;
import io.vertx.ext.web.openapi.impl.BodyProcessorGenerator;
import io.vertx.ext.web.openapi.impl.GeneratorContext;
import io.vertx.ext.web.openapi.impl.JsonPointerIteratorWithLoader;
import io.vertx.ext.web.openapi.impl.NoopBodyProcessorGenerator;
import io.vertx.ext.web.openapi.impl.OpenAPI3Utils;
import io.vertx.ext.web.openapi.impl.OpenAPIHolderImpl;
import io.vertx.ext.web.openapi.impl.OperationImpl;
import io.vertx.ext.web.openapi.impl.ParameterProcessorGenerator;
import io.vertx.ext.web.validation.RequestPredicate;
import io.vertx.ext.web.validation.RequestPredicateResult;
import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.ValidationHandlerImpl;
import io.vertx.ext.web.validation.impl.body.BodyProcessor;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessor;
import io.vertx.json.schema.SchemaParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class OpenAPI3ValidationHandlerGenerator {
    private static final JsonPointer BODY_REQUIRED_POINTER = JsonPointer.from((String)"/requestBody/required");
    private static final JsonPointer REQUEST_BODY_CONTENT_POINTER = JsonPointer.from((String)"/requestBody/content");
    private final OpenAPIHolderImpl holder;
    private final SchemaParser schemaParser;
    private final JsonPointerIteratorWithLoader iteratorWithLoader;
    private final List<ParameterProcessorGenerator> parameterProcessorGenerators;
    private final List<BodyProcessorGenerator> bodyProcessorGenerators;

    public OpenAPI3ValidationHandlerGenerator(OpenAPIHolderImpl holder, SchemaParser schemaParser) {
        this.holder = holder;
        this.schemaParser = schemaParser;
        this.iteratorWithLoader = new JsonPointerIteratorWithLoader(holder);
        this.parameterProcessorGenerators = new ArrayList<ParameterProcessorGenerator>();
        this.bodyProcessorGenerators = new ArrayList<BodyProcessorGenerator>();
    }

    public OpenAPI3ValidationHandlerGenerator addParameterProcessorGenerator(ParameterProcessorGenerator gen) {
        this.parameterProcessorGenerators.add(gen);
        return this;
    }

    public OpenAPI3ValidationHandlerGenerator addBodyProcessorGenerator(BodyProcessorGenerator gen) {
        this.bodyProcessorGenerators.add(gen);
        return this;
    }

    public ValidationHandlerImpl create(OperationImpl operation) {
        HashMap parameterProcessors = new HashMap();
        ArrayList<BodyProcessor> bodyProcessors = new ArrayList<BodyProcessor>();
        GeneratorContext context = new GeneratorContext(this.schemaParser, this.holder, operation);
        for (Map.Entry<JsonPointer, JsonObject> pe : operation.getParameters().entrySet()) {
            ParameterLocation parsedLocation = ParameterLocation.valueOf((String)pe.getValue().getString("in").toUpperCase());
            String parsedStyle = OpenAPI3Utils.resolveStyle(pe.getValue());
            if (pe.getValue().getBoolean("allowReserved", Boolean.valueOf(false)).booleanValue()) {
                throw RouterBuilderException.createUnsupportedSpecFeature("You are using allowReserved keyword in parameter " + pe.getKey() + " which is not supported");
            }
            JsonObject fakeSchema = context.fakeSchema(pe.getValue().getJsonObject("schema", new JsonObject()));
            ParameterProcessorGenerator generator = this.parameterProcessorGenerators.stream().filter(g -> g.canGenerate((JsonObject)pe.getValue(), fakeSchema, parsedLocation, parsedStyle)).findFirst().orElseThrow(() -> RouterBuilderException.cannotFindParameterProcessorGenerator((JsonPointer)pe.getKey(), (JsonObject)pe.getValue()));
            try {
                ParameterProcessor generated = generator.generate(pe.getValue(), fakeSchema, pe.getKey(), parsedLocation, parsedStyle, context);
                if (!parameterProcessors.containsKey(generated.getLocation())) {
                    parameterProcessors.put(generated.getLocation(), new ArrayList());
                }
                ((List)parameterProcessors.get(generated.getLocation())).add(generated);
            }
            catch (Exception e) {
                throw RouterBuilderException.createErrorWhileGeneratingValidationHandler(String.format("Cannot generate parameter validator for parameter %s in %s", pe.getKey().toURI(), parsedLocation), e);
            }
        }
        if (this.parseIsBodyRequired(operation)) {
            context.addPredicate((Function<RoutingContext, RequestPredicateResult>)RequestPredicate.BODY_REQUIRED);
        }
        for (Map.Entry mediaType : (JsonObject)REQUEST_BODY_CONTENT_POINTER.queryOrDefault((Object)operation.getOperationModel(), (JsonPointerIterator)this.iteratorWithLoader, (Object)new JsonObject())) {
            JsonObject mediaTypeModel = (JsonObject)mediaType.getValue();
            JsonPointer mediaTypePointer = operation.getPointer().copy().append("requestBody").append("content").append((String)mediaType.getKey());
            BodyProcessor generated = this.bodyProcessorGenerators.stream().filter(g -> g.canGenerate((String)mediaType.getKey(), mediaTypeModel)).findFirst().orElse(NoopBodyProcessorGenerator.INSTANCE).generate((String)mediaType.getKey(), mediaTypeModel, mediaTypePointer, context);
            bodyProcessors.add(generated);
        }
        return new ValidationHandlerImpl(parameterProcessors, bodyProcessors, context.getPredicates());
    }

    private boolean parseIsBodyRequired(OperationImpl operation) {
        return (Boolean)BODY_REQUIRED_POINTER.queryOrDefault((Object)operation.getOperationModel(), (JsonPointerIterator)this.iteratorWithLoader, (Object)false);
    }
}

