/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.openapi.RouterBuilderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class AuthenticationHandlersStore {
    private static final AuthenticationHandler SUCCESS_HANDLER = new AuthenticationHandlerImpl<AuthenticationProvider>((authInfo, resultHandler) -> resultHandler.handle((Object)Future.succeededFuture((Object)User.create((JsonObject)new JsonObject())))){

        public void parseCredentials(RoutingContext context, Handler<AsyncResult<Credentials>> handler) {
            handler.handle((Object)Future.succeededFuture(JsonObject::new));
        }
    };
    private final Map<String, List<AuthenticationHandler>> securityHandlers = new HashMap<String, List<AuthenticationHandler>>();

    AuthenticationHandlersStore() {
    }

    protected void addAuthnRequirement(String name, AuthenticationHandler handler) {
        this.securityHandlers.computeIfAbsent(name, k -> new ArrayList()).add(handler);
    }

    protected AuthenticationHandler solveAuthenticationHandler(JsonArray securityRequirements, boolean failOnNotFound) {
        return this.orAuths(securityRequirements, failOnNotFound);
    }

    private List<AuthenticationHandler> resolveHandlers(Map.Entry<String, Object> e, boolean failOnNotFound) {
        List<Object> authenticationHandlers = failOnNotFound ? Optional.ofNullable(this.securityHandlers.get(e.getKey())).orElseThrow(() -> RouterBuilderException.createMissingSecurityHandler((String)e.getKey())) : Optional.ofNullable(this.securityHandlers.get(e.getKey())).orElse(Collections.emptyList());
        if (e.getValue() instanceof JsonArray && ((JsonArray)e.getValue()).size() != 0) {
            List scopes = ((JsonArray)e.getValue()).stream().map(v -> (String)v).collect(Collectors.toList());
            authenticationHandlers.stream().filter(h -> h instanceof OAuth2AuthHandler).map(h -> (OAuth2AuthHandler)h).forEach(h -> scopes.forEach(arg_0 -> ((OAuth2AuthHandler)h).withScope(arg_0)));
        }
        return authenticationHandlers;
    }

    private AuthenticationHandler andAuths(JsonObject securityRequirements, boolean failOnNotFound) {
        List<AuthenticationHandler> handlers = securityRequirements.stream().flatMap(e -> this.resolveHandlers((Map.Entry<String, Object>)e, failOnNotFound).stream()).collect(Collectors.toList());
        if (handlers.size() == 0) {
            return null;
        }
        if (handlers.size() == 1) {
            return (AuthenticationHandler)handlers.get(0);
        }
        ChainAuthHandler authHandler = ChainAuthHandler.all();
        handlers.forEach(arg_0 -> ((ChainAuthHandler)authHandler).add(arg_0));
        return authHandler;
    }

    private AuthenticationHandler orAuths(JsonArray securityRequirements, boolean failOnNotFound) {
        if (securityRequirements == null) {
            return null;
        }
        int hasEmptyAuth = securityRequirements.getList().indexOf(new JsonObject());
        if (hasEmptyAuth != -1) {
            securityRequirements.remove(hasEmptyAuth);
        }
        if (securityRequirements.size() == 0) {
            return null;
        }
        if (securityRequirements.size() == 1) {
            return this.andAuths(securityRequirements.getJsonObject(0), failOnNotFound);
        }
        ChainAuthHandler authHandler = ChainAuthHandler.any();
        securityRequirements.stream().map(jo -> (JsonObject)jo).map(jo -> this.andAuths((JsonObject)jo, failOnNotFound)).filter(Objects::nonNull).forEach(arg_0 -> ((ChainAuthHandler)authHandler).add(arg_0));
        if (hasEmptyAuth != -1) {
            authHandler.add(SUCCESS_HANDLER);
        }
        return authHandler;
    }
}

