/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.freemarker.impl;

import freemarker.cache.TemplateLoader;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;

class FreeMarkerTemplateLoader
implements TemplateLoader {
    private final Vertx vertx;

    FreeMarkerTemplateLoader(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public Object findTemplateSource(String name) throws IOException {
        try {
            if (this.vertx.fileSystem().existsBlocking(name)) {
                String templ = this.vertx.fileSystem().readFileBlocking(name).toString(Charset.defaultCharset());
                return new StringTemplateSource(name, templ, System.currentTimeMillis());
            }
            return null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getLastModified(Object templateSource) {
        return ((StringTemplateSource)templateSource).lastModified;
    }

    @Override
    public Reader getReader(Object templateSource, String encoding) {
        return new StringReader(((StringTemplateSource)templateSource).source);
    }

    @Override
    public void closeTemplateSource(Object templateSource) {
    }

    private static class StringTemplateSource {
        private final String name;
        private final String source;
        private final long lastModified;

        StringTemplateSource(String name, String source, long lastModified) {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (source == null) {
                throw new IllegalArgumentException("source == null");
            }
            if (lastModified < -1L) {
                throw new IllegalArgumentException("lastModified < -1L");
            }
            this.name = name;
            this.source = source;
            this.lastModified = lastModified;
        }

        public boolean equals(Object obj) {
            return obj instanceof StringTemplateSource && this.name.equals(((StringTemplateSource)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

