/*
 * Decompiled with CFR 0.152.
 */
package httl.ast;

import httl.Node;
import httl.Template;
import httl.Visitor;
import httl.ast.BinaryOperator;
import httl.ast.BlockDirective;
import httl.ast.BreakDirective;
import httl.ast.Comment;
import httl.ast.Constant;
import httl.ast.ElseDirective;
import httl.ast.EndDirective;
import httl.ast.Expression;
import httl.ast.ForDirective;
import httl.ast.IfDirective;
import httl.ast.LineDirective;
import httl.ast.MacroDirective;
import httl.ast.SetDirective;
import httl.ast.Statement;
import httl.ast.Text;
import httl.ast.UnaryOperator;
import httl.ast.ValueDirective;
import httl.ast.Variable;
import httl.util.ClassUtils;
import java.io.IOException;
import java.text.ParseException;

public abstract class AstVisitor
implements Visitor {
    public boolean visit(Node node) throws IOException, ParseException {
        try {
            if (node instanceof Expression) {
                this.visit((Expression)node);
            } else {
                if (node instanceof Statement) {
                    return this.visit((Statement)node);
                }
                if (node instanceof Template) {
                    return this.visit((Template)node);
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(ClassUtils.toString(e), node.getOffset());
        }
        return true;
    }

    public boolean visit(Statement node) throws IOException, ParseException {
        if (node instanceof Text) {
            this.visit((Text)node);
        } else if (node instanceof Comment) {
            this.visit((Comment)node);
        } else if (node instanceof LineDirective) {
            this.visit((LineDirective)node);
        } else {
            if (node instanceof BlockDirective) {
                return this.visit((BlockDirective)node);
            }
            if (node instanceof EndDirective) {
                this.visit((EndDirective)node);
            }
        }
        return true;
    }

    public void visit(LineDirective node) throws IOException, ParseException {
        if (node instanceof ValueDirective) {
            this.visit((ValueDirective)node);
        } else if (node instanceof SetDirective) {
            this.visit((SetDirective)node);
        } else if (node instanceof BreakDirective) {
            this.visit((BreakDirective)node);
        }
    }

    public boolean visit(BlockDirective node) throws IOException, ParseException {
        if (node instanceof IfDirective) {
            return this.visit((IfDirective)node);
        }
        if (node instanceof ElseDirective) {
            return this.visit((ElseDirective)node);
        }
        if (node instanceof ForDirective) {
            return this.visit((ForDirective)node);
        }
        if (node instanceof MacroDirective) {
            return this.visit((MacroDirective)node);
        }
        return true;
    }

    public void visit(EndDirective node) throws IOException, ParseException {
        BlockDirective start = node.getStart();
        if (start instanceof IfDirective) {
            this.end((IfDirective)start);
        } else if (start instanceof ElseDirective) {
            this.end((ElseDirective)start);
        } else if (start instanceof ForDirective) {
            this.end((ForDirective)start);
        } else if (start instanceof MacroDirective) {
            this.end((MacroDirective)start);
        }
    }

    public void visit(Expression node) throws IOException, ParseException {
        if (node instanceof Constant) {
            this.visit((Constant)node);
        } else if (node instanceof Variable) {
            this.visit((Variable)node);
        } else if (node instanceof UnaryOperator) {
            this.visit((UnaryOperator)node);
        } else if (node instanceof BinaryOperator) {
            this.visit((BinaryOperator)node);
        }
    }

    public void visit(UnaryOperator node) throws IOException, ParseException {
    }

    public void visit(BinaryOperator node) throws IOException, ParseException {
    }

    public void visit(Constant node) throws IOException, ParseException {
    }

    public void visit(Variable node) throws IOException, ParseException {
    }

    public void visit(Text node) throws IOException, ParseException {
    }

    public void visit(ValueDirective node) throws IOException, ParseException {
    }

    public void visit(Comment node) throws IOException, ParseException {
    }

    public void visit(SetDirective node) throws IOException, ParseException {
    }

    public void visit(BreakDirective node) throws IOException, ParseException {
    }

    public boolean visit(Template node) throws IOException, ParseException {
        return true;
    }

    public boolean visit(IfDirective node) throws IOException, ParseException {
        return true;
    }

    public boolean visit(ElseDirective node) throws IOException, ParseException {
        return true;
    }

    public boolean visit(ForDirective node) throws IOException, ParseException {
        return true;
    }

    public boolean visit(MacroDirective node) throws IOException, ParseException {
        return true;
    }

    public void end(IfDirective node) throws IOException, ParseException {
    }

    public void end(ElseDirective node) throws IOException, ParseException {
    }

    public void end(ForDirective node) throws IOException, ParseException {
    }

    public void end(MacroDirective node) throws IOException, ParseException {
    }
}

