/*
 * Decompiled with CFR 0.152.
 */
package httl.ast;

import httl.ast.BlockDirective;
import httl.ast.Expression;
import httl.util.StringUtils;
import java.lang.reflect.Type;
import java.text.ParseException;

public class ForDirective
extends BlockDirective {
    private final Type type;
    private final String name;
    private final Expression expression;

    public ForDirective(Type type, String name, Expression expression, int offset) throws ParseException {
        super(offset);
        if (!StringUtils.isNamed(name)) {
            throw new ParseException("Illegal foreach name " + name + ", Can not contains any symbol.", offset);
        }
        if (expression == null) {
            throw new ParseException("The foreach expression is required.", offset);
        }
        this.type = type;
        this.name = name;
        this.expression = expression;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toString() {
        String typeName = this.type == null ? "" : (this.type instanceof Class ? ((Class)this.type).getCanonicalName() : this.type.toString());
        return "#for(" + typeName + " " + this.name + " : " + this.expression + ")";
    }
}

