/*
 * Decompiled with CFR 0.152.
 */
package httl.ast;

import httl.Node;
import httl.ast.Expression;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operator
extends Expression {
    private final String name;
    private final int priority;
    private List<Node> children;

    public Operator(String name, int priority, int offset) {
        super(offset);
        this.name = name;
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<Node> getChildren() {
        return this.children == null ? Collections.EMPTY_LIST : this.children;
    }

    public void setChildren(List<Expression> children) throws ParseException {
        if (this.children != null) {
            throw new ParseException("Can not modify operator parameters.", this.getOffset());
        }
        for (Expression node : children) {
            node.setParent(this);
        }
        this.children = Collections.unmodifiableList(children);
    }

    public String toString() {
        return this.getName();
    }
}

