/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.codecs;

import httl.spi.codecs.AbstractJsonCodec;
import java.text.ParseException;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonCodec
extends AbstractJsonCodec {
    private static ObjectMapper mapper = new ObjectMapper();

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static void setMapper(ObjectMapper mapper) {
        JacksonCodec.mapper = mapper;
    }

    @Override
    public String toString(String key, Object value) {
        if (value == null) {
            return null;
        }
        try {
            return mapper.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize " + value + " using jackson, cause: " + e.getMessage(), e);
        }
    }

    @Override
    public byte[] toBytes(String key, Object value) {
        if (value == null) {
            return null;
        }
        try {
            return mapper.writeValueAsBytes(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize " + value + " using jackson, cause: " + e.getMessage(), e);
        }
    }

    @Override
    public <T> T valueOf(String str, Class<T> type) throws ParseException {
        if (str == null) {
            return null;
        }
        try {
            return (T)mapper.readValue(str, type);
        }
        catch (Exception e) {
            int offset = 0;
            if (e instanceof JsonProcessingException) {
                offset = (int)((JsonProcessingException)e).getLocation().getCharOffset();
            }
            throw new ParseException("Failed to parse " + str + " using jackson, cause: " + e.getMessage(), offset);
        }
    }

    @Override
    public <T> T valueOf(byte[] str, Class<T> type) throws ParseException {
        if (str == null) {
            return null;
        }
        try {
            return (T)mapper.readValue(str, type);
        }
        catch (Exception e) {
            int offset = 0;
            if (e instanceof JsonProcessingException) {
                offset = (int)((JsonProcessingException)e).getLocation().getCharOffset();
            }
            throw new ParseException("Failed to parse " + this.toString(str) + " using jackson, cause: " + e.getMessage(), offset);
        }
    }
}

