/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.codecs;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import httl.spi.codecs.AbstractXmlCodec;
import httl.util.UnsafeByteArrayInputStream;
import httl.util.UnsafeByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XstreamCodec
extends AbstractXmlCodec {
    private static XStream XSTREAM = new XStream((HierarchicalStreamDriver)new Xpp3Driver());

    public static XStream getXStream() {
        return XSTREAM;
    }

    public static void setDriver(HierarchicalStreamDriver driver) {
        XSTREAM = new XStream(driver);
    }

    @Override
    public String toString(String key, Object value) {
        return XSTREAM.toXML(value);
    }

    @Override
    public byte[] toBytes(String key, Object value) {
        UnsafeByteArrayOutputStream out = new UnsafeByteArrayOutputStream();
        XSTREAM.toXML(value, (OutputStream)out);
        return out.toByteArray();
    }

    @Override
    public <T> T valueOf(String str, Class<T> type) throws ParseException {
        if (str == null) {
            return null;
        }
        if (type == null) {
            return (T)XSTREAM.fromXML(str);
        }
        try {
            return (T)XSTREAM.fromXML(str, type.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public <T> T valueOf(byte[] str, Class<T> type) throws ParseException {
        if (str == null) {
            return null;
        }
        if (type == null) {
            return (T)XSTREAM.fromXML((InputStream)new UnsafeByteArrayInputStream(str));
        }
        try {
            return (T)XSTREAM.fromXML((InputStream)new UnsafeByteArrayInputStream(str), type.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

