/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.codecs.json;

import httl.spi.Converter;
import httl.spi.codecs.json.JSONValue;
import httl.util.ClassUtils;
import httl.util.Stack;
import httl.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONVisitor {
    public static final String CLASS_PROPERTY = "class";
    public static final boolean[] EMPTY_BOOL_ARRAY = new boolean[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Class<?>[] currentTypes;
    private Class<?> currentType = Object[].class;
    private Object currentValue;
    private Map<String, Object> currentWrapper;
    private JSONValue jsonValue;
    private Converter<Object, Map<String, Object>> converter;
    private Stack<Object> stack = new Stack();

    JSONVisitor(Class<?> type, JSONValue jc, Converter<Object, Map<String, Object>> mc) {
        this.currentType = type;
        this.jsonValue = jc;
        this.converter = mc;
    }

    JSONVisitor(Class<?>[] types, JSONValue jc) {
        this.currentTypes = types;
        this.jsonValue = jc;
    }

    public void begin() {
    }

    public Object end(Object obj, boolean isValue) throws ParseException {
        this.stack.clear();
        try {
            return this.jsonValue.readValue(this.currentType, obj);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void objectBegin() throws ParseException {
        this.stack.push(this.currentValue);
        this.stack.push(this.currentType);
        this.stack.push(this.currentWrapper);
        if (this.currentType == Object.class || Map.class.isAssignableFrom(this.currentType)) {
            if (!this.currentType.isInterface() && this.currentType != Object.class) {
                try {
                    this.currentValue = this.currentType.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            } else {
                this.currentValue = this.currentType == ConcurrentMap.class ? new ConcurrentHashMap() : new HashMap();
            }
            this.currentWrapper = null;
        } else {
            try {
                this.currentValue = this.currentType.newInstance();
                this.currentWrapper = this.converter.convert(this.currentValue, null);
            }
            catch (IllegalAccessException e) {
                throw new ParseException(StringUtils.toString(e), 0);
            }
            catch (InstantiationException e) {
                throw new ParseException(StringUtils.toString(e), 0);
            }
            catch (IOException e) {
                throw new ParseException(StringUtils.toString(e), 0);
            }
        }
    }

    public Object objectEnd(int count) {
        String className;
        Class<?> cls;
        Map map;
        Object obj;
        Object ret = this.currentValue;
        this.currentWrapper = (Map)this.stack.pop();
        this.currentType = (Class)this.stack.pop();
        this.currentValue = this.stack.pop();
        if (ret instanceof Map && (obj = (map = (Map)ret).get(CLASS_PROPERTY)) instanceof String && !(cls = ClassUtils.forName(className = (String)obj)).isInterface() && !cls.isPrimitive() && !cls.isAssignableFrom(ret.getClass())) {
            try {
                Object value = cls.newInstance();
                if (value instanceof Map) {
                    ((Map)value).putAll((Map)ret);
                } else {
                    ClassUtils.setProperties(value, (Map)ret);
                }
                ret = value;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public void objectItem(String name) {
        this.stack.push(name);
        Class v = this.currentWrapper == null ? null : (Class)this.currentWrapper.get(name + "." + CLASS_PROPERTY);
        this.currentType = v == null ? Object.class : v;
    }

    public void objectItemValue(Object obj, boolean isValue) throws ParseException {
        String name = (String)this.stack.pop();
        if (this.currentWrapper == null) {
            ((Map)this.currentValue).put(name, obj);
        } else if (this.currentType != null) {
            if (isValue && obj != null) {
                try {
                    obj = this.jsonValue.readValue(this.currentType, obj);
                }
                catch (IOException e) {
                    throw new ParseException(StringUtils.toString(e), 0);
                }
            }
            if (this.currentValue instanceof Throwable && "message".equals(name)) {
                try {
                    Field field = Throwable.class.getDeclaredField("detailMessage");
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(this.currentValue, obj);
                }
                catch (NoSuchFieldException e) {
                    throw new ParseException(StringUtils.toString(e), 0);
                }
                catch (IllegalAccessException e) {
                    throw new ParseException(StringUtils.toString(e), 0);
                }
            } else if (!CLASS_PROPERTY.equals(name) || this.currentValue instanceof Map) {
                this.currentWrapper.put(name, obj);
            }
        }
    }

    public void arrayBegin() throws ParseException {
        this.stack.push(this.currentType);
        if (this.currentType.isArray()) {
            this.currentType = this.currentType.getComponentType();
        } else if (this.currentType == Object.class || Collection.class.isAssignableFrom(this.currentType)) {
            this.currentType = Object.class;
        } else {
            throw new ParseException("Convert error, can not load json array data into class [" + this.currentType.getName() + "].", 0);
        }
    }

    public Object arrayEnd(int count) throws ParseException {
        AbstractCollection ret;
        this.currentType = (Class)this.stack.get(-1 - count);
        if (this.currentType.isArray()) {
            ret = JSONVisitor.toArray(this.currentType.getComponentType(), this.stack, count);
        } else {
            AbstractCollection items;
            if (this.currentType == Object.class || Collection.class.isAssignableFrom(this.currentType)) {
                if (!this.currentType.isInterface() && this.currentType != Object.class) {
                    try {
                        items = (ArrayList)this.currentType.newInstance();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                } else {
                    items = this.currentType.isAssignableFrom(ArrayList.class) ? new ArrayList(count) : (this.currentType.isAssignableFrom(HashSet.class) ? new HashSet(count) : (this.currentType.isAssignableFrom(LinkedList.class) ? new LinkedList() : new ArrayList(count)));
                }
            } else {
                throw new ParseException("Convert error, can not load json array data into class [" + this.currentType.getName() + "].", 0);
            }
            for (int i = 0; i < count; ++i) {
                items.add(this.stack.remove(i - count));
            }
            ret = items;
        }
        this.stack.pop();
        return ret;
    }

    public void arrayItem(int index) throws ParseException {
        if (this.currentTypes != null && this.stack.size() == index + 1) {
            if (index < this.currentTypes.length) {
                this.currentType = this.currentTypes[index];
            } else {
                throw new ParseException("Can not load json array data into [" + JSONVisitor.name(this.currentTypes) + "].", 0);
            }
        }
    }

    public void arrayItemValue(int index, Object obj, boolean isValue) throws ParseException {
        if (isValue && obj != null) {
            try {
                obj = this.jsonValue.readValue(this.currentType, obj);
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
        this.stack.push(obj);
    }

    private static Object toArray(Class<?> c, Stack<Object> list, int len) throws ParseException {
        if (c == String.class) {
            if (len == 0) {
                return EMPTY_STRING_ARRAY;
            }
            String[] ss = new String[len];
            for (int i = len - 1; i >= 0; --i) {
                Object o = list.pop();
                ss[i] = o == null ? null : o.toString();
            }
            return ss;
        }
        if (c == Boolean.TYPE) {
            if (len == 0) {
                return EMPTY_BOOL_ARRAY;
            }
            boolean[] ret = new boolean[len];
            for (int i = len - 1; i >= 0; --i) {
                Object o = list.pop();
                if (!(o instanceof Boolean)) continue;
                ret[i] = (Boolean)o;
            }
            return ret;
        }
        if (c == Integer.TYPE) {
            if (len == 0) {
                return EMPTY_INT_ARRAY;
            }
            int[] ret = new int[len];
            for (int i = len - 1; i >= 0; --i) {
                Object o = list.pop();
                if (!(o instanceof Number)) continue;
                ret[i] = ((Number)o).intValue();
            }
            return ret;
        }
        if (c == Long.TYPE) {
            if (len == 0) {
                return EMPTY_LONG_ARRAY;
            }
            long[] ret = new long[len];
            for (int i = len - 1; i >= 0; --i) {
                Object o = list.pop();
                if (!(o instanceof Number)) continue;
                ret[i] = ((Number)o).longValue();
            }
            return ret;
        }
        if (c == Float.TYPE) {
            if (len == 0) {
                return EMPTY_FLOAT_ARRAY;
            }
            float[] ret = new float[len];
            for (int i = len - 1; i >= 0; --i) {
                Object o = list.pop();
                if (!(o instanceof Number)) continue;
                ret[i] = ((Number)o).floatValue();
            }
            return ret;
        }
        if (c == Double.TYPE) {
            if (len == 0) {
                return EMPTY_DOUBLE_ARRAY;
            }
            double[] ret = new double[len];
            for (int i = len - 1; i >= 0; --i) {
                Object o = list.pop();
                if (!(o instanceof Number)) continue;
                ret[i] = ((Number)o).doubleValue();
            }
            return ret;
        }
        if (c == Byte.TYPE) {
            if (len == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            byte[] ret = new byte[len];
            for (int i = len - 1; i >= 0; --i) {
                Object o = list.pop();
                if (!(o instanceof Number)) continue;
                ret[i] = ((Number)o).byteValue();
            }
            return ret;
        }
        if (c == Character.TYPE) {
            if (len == 0) {
                return EMPTY_CHAR_ARRAY;
            }
            char[] ret = new char[len];
            for (int i = len - 1; i >= 0; --i) {
                Object o = list.pop();
                if (!(o instanceof Character)) continue;
                ret[i] = ((Character)o).charValue();
            }
            return ret;
        }
        if (c == Short.TYPE) {
            if (len == 0) {
                return EMPTY_SHORT_ARRAY;
            }
            short[] ret = new short[len];
            for (int i = len - 1; i >= 0; --i) {
                Object o = list.pop();
                if (!(o instanceof Number)) continue;
                ret[i] = ((Number)o).shortValue();
            }
            return ret;
        }
        Object ret = Array.newInstance(c, len);
        for (int i = len - 1; i >= 0; --i) {
            Array.set(ret, i, list.pop());
        }
        return ret;
    }

    private static String name(Class<?>[] types) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(types[i].getName());
        }
        return sb.toString();
    }
}

