/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.converters;

import httl.spi.Compiler;
import httl.spi.Converter;
import httl.spi.Logger;
import httl.util.ClassUtils;
import httl.util.MapSupport;
import httl.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMapConverter
implements Converter<Object, Map<String, Object>> {
    private static final ConcurrentMap<Class<?>, Class<?>> BEAN_WRAPPERS = new ConcurrentHashMap();
    private Compiler compiler;

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public Map<String, Object> convert(Object bean, Map<String, Class<?>> types) throws IOException, ParseException {
        if (bean == null) {
            return null;
        }
        Class<?> beanClass = bean.getClass();
        Class<?> wrapperClass = (Class<?>)BEAN_WRAPPERS.get(beanClass);
        if (wrapperClass == null) {
            try {
                wrapperClass = BeanMapConverter.getMapClass(beanClass, this.compiler);
                Class<?> old = BEAN_WRAPPERS.putIfAbsent(beanClass, wrapperClass);
                if (old != null) {
                    wrapperClass = old;
                }
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        try {
            return (Map)wrapperClass.getConstructor(beanClass).newInstance(bean);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Class<?> getBeanClass(String className, Map<String, Class<?>> properties, Compiler compiler, Logger logger) throws ParseException {
        StringBuilder fields = new StringBuilder();
        StringBuilder gets = new StringBuilder();
        StringBuilder sets = new StringBuilder();
        HashSet<String> added = new HashSet<String>();
        for (Map.Entry<String, Class<?>> entry : properties.entrySet()) {
            String name = entry.getKey();
            String type = entry.getValue().getCanonicalName();
            String method = name.substring(0, 1).toUpperCase() + name.substring(1);
            String fname = ClassUtils.filterJavaKeyword(name);
            if (added.contains(fname)) continue;
            added.add(fname);
            fields.append("private " + type + " " + fname + ";\n");
            gets.append("public " + type + " get" + method + "() {\n");
            gets.append("\treturn " + fname + ";\n");
            gets.append("}\n");
            sets.append("public void set" + method + "(" + type + " " + fname + ") {\n");
            sets.append("\tthis." + fname + " = " + fname + ";\n");
            sets.append("}\n");
        }
        StringBuilder code = new StringBuilder();
        className = "MapBean_" + StringUtils.getVaildName(className);
        code.append("package " + BeanMapConverter.class.getPackage().getName() + ";\n");
        code.append("public class " + className + " {\n");
        code.append((CharSequence)fields);
        code.append((CharSequence)gets);
        code.append((CharSequence)sets);
        code.append("}\n");
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(code.toString());
        }
        return compiler.compile(code.toString());
    }

    public static Class<?> getMapClass(Class<?> beanClass, Compiler compiler) throws ParseException {
        String var;
        HashSet<String> fields = new HashSet<String>();
        StringBuilder keys = new StringBuilder();
        StringBuilder gets = new StringBuilder();
        StringBuilder clss = new StringBuilder();
        StringBuilder puts = new StringBuilder();
        for (Field field : beanClass.getFields()) {
            String key = field.getName();
            if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            fields.add(key);
            if (keys.length() > 0) {
                keys.append(", ");
            }
            keys.append("\"" + key + "\"");
            if (gets.length() > 0) {
                gets.append("else ");
            }
            String call = "bean." + key;
            if (field.getType().isPrimitive()) {
                call = ClassUtils.class.getName() + ".boxed(" + call + ")";
            }
            gets.append("if (\"" + key + "\".equals(key)) return " + call + ";\n");
            clss.append("else if (\"" + key + ".class\".equals(key)) return " + field.getType().getCanonicalName() + ".class;\n");
            if (Modifier.isFinal(field.getModifiers())) continue;
            if (puts.length() > 0) {
                puts.append("else ");
            }
            var = field.getType().isPrimitive() ? ClassUtils.class.getName() + ".unboxed((" + ClassUtils.getBoxedClass(field.getType()).getCanonicalName() + ") value)" : "(" + field.getType().getCanonicalName() + ") value";
            puts.append("if (\"" + key + "\".equals(key)) bean." + key + " = " + var + ";\n");
        }
        for (AccessibleObject accessibleObject : beanClass.getMethods()) {
            String key;
            String name = ((Method)accessibleObject).getName();
            if ((name.length() > 3 && name.startsWith("get") || name.length() > 2 && name.startsWith("is")) && Modifier.isPublic(((Method)accessibleObject).getModifiers()) && ((Method)accessibleObject).getReturnType() != Void.TYPE && ((Method)accessibleObject).getParameterTypes().length == 0 && ((Method)accessibleObject).getDeclaringClass() != Object.class) {
                int i = name.startsWith("get") ? 3 : 2;
                String key2 = name.substring(i, i + 1).toLowerCase() + name.substring(i + 1);
                if (fields.contains(key2)) continue;
                if (keys.length() > 0) {
                    keys.append(", ");
                }
                keys.append("\"" + key2 + "\"");
                if (gets.length() > 0) {
                    gets.append("else ");
                }
                String call = "bean." + name + "()";
                if (((Method)accessibleObject).getReturnType().isPrimitive()) {
                    call = ClassUtils.class.getName() + ".boxed(" + call + ")";
                }
                gets.append("if (\"" + key2 + "\".equals(key)) return " + call + ";\n");
                clss.append("else if (\"" + key2 + ".class\".equals(key)) return " + ((Method)accessibleObject).getReturnType().getCanonicalName() + ".class;\n");
                continue;
            }
            if (name.length() <= 3 || !name.startsWith("set") || !Modifier.isPublic(((Method)accessibleObject).getModifiers()) || ((Method)accessibleObject).getParameterTypes().length != 1 || ((Method)accessibleObject).getDeclaringClass() == Object.class || fields.contains(key = name.substring(3, 4).toLowerCase() + name.substring(4))) continue;
            if (puts.length() > 0) {
                puts.append("else ");
            }
            var = ((Method)accessibleObject).getParameterTypes()[0].isPrimitive() ? ClassUtils.class.getName() + ".unboxed((" + ClassUtils.getBoxedClass(((Method)accessibleObject).getParameterTypes()[0]).getCanonicalName() + ") value)" : "(" + ((Method)accessibleObject).getParameterTypes()[0].getCanonicalName() + ") value";
            puts.append("if (\"" + key + "\".equals(key)) bean." + name + "(" + var + ");\n");
        }
        StringBuilder code = new StringBuilder();
        String className = "BeanMap_" + beanClass.getCanonicalName().replace('.', '_');
        code.append("package " + BeanMapConverter.class.getPackage().getName() + ";\n");
        code.append("public class " + className + " extends " + MapSupport.class.getName() + " {\n");
        code.append("private " + beanClass.getCanonicalName() + " bean;\n");
        code.append("public " + className + "(" + beanClass.getCanonicalName() + " bean) {\n");
        if (keys.length() > 0) {
            code.append("super(new String[] {" + keys + "});\n");
        }
        code.append("this.bean = bean;\n");
        code.append("}\n");
        code.append("public Object get(Object key) {\n");
        code.append((CharSequence)gets);
        code.append((CharSequence)clss);
        code.append("return null;\n");
        code.append("}\n");
        code.append("public Object put(Object key, Object value) {\n");
        code.append("Object old = get(key);\n");
        code.append((CharSequence)puts);
        code.append("return old;\n");
        code.append("}\n");
        code.append("}\n");
        try {
            return compiler.compile(code.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage() + "\n====\n" + code.toString() + "\n====\n", e);
        }
    }
}

