/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.filters;

import httl.spi.filters.AbstractFilter;
import httl.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;

public class AttributeSyntaxFilter
extends AbstractFilter {
    private String ifattr = "ifattr";
    private String setattr = "setattr";
    private String[] setDirective = new String[]{"var"};
    private String[] ifDirective = new String[]{"if"};
    private String[] elseifDirective = new String[]{"elseif"};
    private String[] elseDirective = new String[]{"else"};
    private String[] forDirective = new String[]{"for"};
    private String[] breakifDirective = new String[]{"breakif"};
    private String[] macroDirective = new String[]{"macro"};
    private String[] endDirective = new String[]{"end"};
    private String attributeNamespace;

    public void setSetDirective(String[] setDirective) {
        this.setDirective = setDirective;
    }

    public void setIfDirective(String[] ifDirective) {
        this.ifDirective = ifDirective;
    }

    public void setElseifDirective(String[] elseifDirective) {
        this.elseifDirective = elseifDirective;
    }

    public void setElseDirective(String[] elseDirective) {
        this.elseDirective = elseDirective;
    }

    public void setForDirective(String[] forDirective) {
        this.forDirective = forDirective;
    }

    public void setBreakifDirective(String[] breakifDirective) {
        this.breakifDirective = breakifDirective;
    }

    public void setMacroDirective(String[] macroDirective) {
        this.macroDirective = macroDirective;
    }

    public void setEndDirective(String[] endDirective) {
        this.endDirective = endDirective;
    }

    public void setAttributeNamespace(String attributeNamespace) {
        if (!attributeNamespace.endsWith(":")) {
            attributeNamespace = attributeNamespace + ":";
        }
        this.attributeNamespace = attributeNamespace;
    }

    private boolean isDirective(String name) {
        return StringUtils.inArray(name, this.setDirective) || StringUtils.inArray(name, this.ifDirective) || StringUtils.inArray(name, this.elseifDirective) || StringUtils.inArray(name, this.elseDirective) || StringUtils.inArray(name, this.forDirective) || StringUtils.inArray(name, this.breakifDirective) || StringUtils.inArray(name, this.macroDirective) || StringUtils.inArray(name, this.endDirective);
    }

    private boolean isBlockDirective(String name) {
        return StringUtils.inArray(name, this.ifDirective) || StringUtils.inArray(name, this.elseifDirective) || StringUtils.inArray(name, this.elseDirective) || StringUtils.inArray(name, this.forDirective) || StringUtils.inArray(name, this.macroDirective);
    }

    public String filter(String key, String value) {
        Source source = new Source((CharSequence)value);
        OutputDocument document = new OutputDocument(source);
        this.replaceChildren(source, (Segment)source, document);
        return document.toString();
    }

    private void replaceChildren(Source source, Segment segment, OutputDocument document) {
        List elements = segment.getChildElements();
        if (elements != null) {
            for (Element element : elements) {
                String directiveName;
                String name;
                if (element == null) continue;
                ArrayList<String> directiveNames = new ArrayList<String>();
                ArrayList<String> directiveValues = new ArrayList<String>();
                ArrayList<Attribute> directiveAttributes = new ArrayList<Attribute>();
                Attributes attributes = element.getAttributes();
                if (attributes != null) {
                    for (Attribute attribute : attributes) {
                        if (attribute == null || (name = attribute.getName()) == null || !this.isDirective(name) && (this.attributeNamespace == null || !name.startsWith(this.attributeNamespace) || !this.isDirective(name.substring(this.attributeNamespace.length())))) continue;
                        String directiveName2 = this.attributeNamespace != null ? name.substring(this.attributeNamespace.length()) : name;
                        String value = attribute.getValue();
                        directiveNames.add(directiveName2);
                        directiveValues.add(value);
                        directiveAttributes.add(attribute);
                    }
                }
                if (directiveNames.size() > 0) {
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < directiveNames.size(); ++i) {
                        directiveName = (String)directiveNames.get(i);
                        String directiveValue = (String)directiveValues.get(i);
                        buf.append("#");
                        buf.append(directiveName);
                        buf.append("(");
                        buf.append(directiveValue);
                        buf.append(")");
                    }
                    document.insert(element.getBegin(), (CharSequence)buf.toString());
                }
                for (int i = 0; i < directiveAttributes.size(); ++i) {
                    Attribute attribute = (Attribute)directiveAttributes.get(i);
                    document.remove(new Segment(source, attribute.getBegin() - 1, attribute.getEnd()));
                }
                if (attributes != null) {
                    String buf;
                    Attribute oriattr;
                    String expression;
                    String attrName;
                    String[] arr;
                    String val;
                    for (Attribute attribute : attributes) {
                        if (attribute == null || !this.ifattr.equals(name = attribute.getName())) continue;
                        val = attribute.getValue();
                        arr = val.split(",");
                        attrName = arr[0].trim();
                        expression = arr[1].trim();
                        oriattr = attributes.get(attrName);
                        if (oriattr == null) continue;
                        buf = String.format("#if(%s)%s=\"%s\"#end()", expression, oriattr.getName(), oriattr.getValue());
                        document.replace(new Segment(source, oriattr.getBegin(), oriattr.getEnd()), (CharSequence)buf);
                        document.remove(new Segment(source, attribute.getBegin(), attribute.getEnd()));
                    }
                    for (Attribute attribute : attributes) {
                        if (attribute == null || !this.setattr.equals(name = attribute.getName())) continue;
                        val = attribute.getValue();
                        arr = val.split(",");
                        attrName = arr[0].trim();
                        expression = arr[1].trim();
                        oriattr = attributes.get(attrName);
                        buf = String.format("%s=\"%s\"", attrName, expression);
                        document.replace(new Segment(source, attribute.getBegin(), attribute.getEnd()), (CharSequence)buf);
                        if (oriattr == null) continue;
                        document.remove(new Segment(source, attribute.getBegin(), attribute.getEnd()));
                    }
                }
                this.replaceChildren(source, (Segment)element, document);
                if (directiveNames.size() > 0) {
                    StringBuffer buf = new StringBuffer();
                    for (int i = directiveNames.size() - 1; i >= 0; --i) {
                        directiveName = (String)directiveNames.get(i);
                        if (!this.isBlockDirective(directiveName)) continue;
                        buf.append("#");
                        buf.append(this.endDirective[0]);
                        buf.append("(");
                        buf.append(directiveName);
                        buf.append(")");
                    }
                    document.insert(element.getEnd(), (CharSequence)buf.toString());
                }
                directiveNames.clear();
                directiveValues.clear();
                directiveAttributes.clear();
            }
        }
    }
}

