/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.interceptors;

import httl.Context;
import httl.spi.Interceptor;
import httl.spi.Listener;
import httl.util.Reqiured;
import java.io.IOException;
import java.text.ParseException;

public class MultiInterceptor
implements Interceptor {
    private static final String LISTENER_KEY = "__listener__";
    private Listener chain;

    @Reqiured
    public void setInterceptors(Interceptor[] interceptors) {
        Listener last = null;
        for (int i = interceptors.length - 1; i >= 0; --i) {
            final Interceptor current = interceptors[i];
            final Listener next = last;
            last = new Listener(){

                public void render(Context context) throws IOException, ParseException {
                    if (next == null) {
                        Listener listener = (Listener)context.get(MultiInterceptor.LISTENER_KEY);
                        if (listener != null) {
                            current.render(context, listener);
                        }
                    } else {
                        current.render(context, next);
                    }
                }
            };
        }
        this.chain = last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Context context, Listener listener) throws IOException, ParseException {
        if (this.chain != null) {
            Object old = context.put(LISTENER_KEY, (Object)listener);
            try {
                this.chain.render(context);
            }
            finally {
                if (old != null) {
                    context.put(LISTENER_KEY, old);
                } else {
                    context.remove(LISTENER_KEY);
                }
            }
        } else {
            listener.render(context);
        }
    }
}

