/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders;

import httl.Engine;
import httl.Resource;
import httl.spi.Loader;
import httl.spi.loaders.resources.StringResource;
import httl.util.LocaleUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLoader
implements Loader {
    private static final String STRING_ENCODING = "UTF-8";
    private final Map<String, StringResource> templates = new ConcurrentHashMap<String, StringResource>();
    private Engine engine;

    public StringLoader() {
    }

    public StringLoader(Engine engine) {
        this.engine = engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void add(String name, String source) {
        this.add(name, null, source);
    }

    public void add(String name, Locale locale, String source) {
        this.templates.put(this.getTemplateKey(name, locale), new StringResource(this.engine, name, locale, STRING_ENCODING, System.currentTimeMillis(), source));
    }

    public void remove(String name) {
        this.remove(name, null);
    }

    public void remove(String name, Locale locale) {
        this.templates.remove(this.getTemplateKey(name, locale));
    }

    public void clear() {
        this.templates.clear();
    }

    @Override
    public List<String> list(String suffix) throws IOException {
        return new ArrayList<String>(this.templates.keySet());
    }

    @Override
    public Resource load(String name, Locale locale, String encoding) throws IOException {
        StringResource resource = this.templates.get(this.getTemplateKey(name, locale));
        if (resource == null) {
            throw new FileNotFoundException("Not found template " + name);
        }
        return resource;
    }

    @Override
    public boolean exists(String name, Locale locale) {
        return this.templates.containsKey(this.getTemplateKey(name, locale));
    }

    private String getTemplateKey(String name, Locale locale) {
        return LocaleUtils.appendLocale(name, locale);
    }
}

