/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loggers;

import httl.spi.Logger;

public class SimpleLogger
implements Logger {
    private static final String PREFIX = "[httl] ";
    private static final int TRACE = -2;
    private static final int DEBUG = -1;
    private static final int INFO = 0;
    private static final int WARN = 1;
    private static final int ERROR = 2;
    private int level = 0;

    public void setLoggerLevel(String level) {
        if ("TRACE".equalsIgnoreCase(level)) {
            this.level = -2;
        } else if ("DEBUG".equalsIgnoreCase(level)) {
            this.level = -1;
        } else if ("INFO".equalsIgnoreCase(level)) {
            this.level = 0;
        } else if ("WARN".equalsIgnoreCase(level)) {
            this.level = 1;
        } else if ("ERROR".equalsIgnoreCase(level)) {
            this.level = 2;
        }
    }

    private String getMessage(String msg) {
        if (PREFIX == null) {
            return msg;
        }
        return PREFIX + msg;
    }

    public void trace(String msg) {
        if (this.level > -2) {
            return;
        }
        System.out.println(this.getMessage(msg));
    }

    public void trace(Throwable e) {
        if (this.level > -2) {
            return;
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void trace(String msg, Throwable e) {
        if (this.level > -2) {
            return;
        }
        System.out.println(this.getMessage(msg));
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void debug(String msg) {
        if (this.level > -1) {
            return;
        }
        System.out.println(this.getMessage(msg));
    }

    public void debug(Throwable e) {
        if (this.level > -1) {
            return;
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void debug(String msg, Throwable e) {
        if (this.level > -1) {
            return;
        }
        System.out.println(this.getMessage(msg));
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void info(String msg) {
        if (this.level > 0) {
            return;
        }
        System.out.println(this.getMessage(msg));
    }

    public void info(Throwable e) {
        if (this.level > 0) {
            return;
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void info(String msg, Throwable e) {
        if (this.level > 0) {
            return;
        }
        System.out.println(this.getMessage(msg));
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void warn(String msg) {
        if (this.level > 1) {
            return;
        }
        System.err.println(this.getMessage(msg));
    }

    public void warn(Throwable e) {
        if (this.level > 1) {
            return;
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void warn(String msg, Throwable e) {
        if (this.level > 1) {
            return;
        }
        System.err.println(this.getMessage(msg));
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void error(String msg) {
        if (this.level > 2) {
            return;
        }
        System.err.println(this.getMessage(msg));
    }

    public void error(Throwable e) {
        if (this.level > 2) {
            return;
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void error(String msg, Throwable e) {
        if (this.level > 2) {
            return;
        }
        System.err.println(this.getMessage(msg));
        if (e != null) {
            e.printStackTrace();
        }
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }
}

