/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.methods;

import httl.Context;
import httl.Engine;
import httl.Resource;
import httl.Template;
import httl.util.IOUtils;
import httl.util.StringUtils;
import httl.util.UrlUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMethod {
    private Engine engine;
    private String extendsDirectory;

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void setExtendsDirectory(String extendsDirectory) {
        this.extendsDirectory = UrlUtils.cleanDirectory(extendsDirectory);
        if ("/".equals(this.extendsDirectory)) {
            this.extendsDirectory = null;
        }
    }

    public Template $extends(String name) throws IOException, ParseException {
        return this.$extends(name, (Locale)null, (String)null);
    }

    public Template $extends(String name, String encoding) throws IOException, ParseException {
        return this.$extends(name, (Locale)null, encoding);
    }

    public Template $extends(String name, Locale locale) throws IOException, ParseException {
        return this.$extends(name, locale, (String)null);
    }

    public Template $extends(String name, Locale locale, String encoding) throws IOException, ParseException {
        Template template;
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("include template name == null");
        }
        String macro = null;
        int i = name.indexOf(35);
        if (i > 0) {
            macro = name.substring(i + 1);
            name = name.substring(0, i);
        }
        if ((template = Context.getContext().getTemplate()) != null) {
            if (StringUtils.isEmpty(encoding)) {
                encoding = template.getEncoding();
            }
            name = UrlUtils.relativeUrl(name, template.getName());
            if (locale == null) {
                locale = template.getLocale();
            }
        }
        if (StringUtils.isNotEmpty(this.extendsDirectory)) {
            name = this.extendsDirectory + name;
        }
        Template extend = this.engine.getTemplate(name, locale, encoding);
        if (StringUtils.isNotEmpty(macro)) {
            extend = extend.getMacros().get(macro);
        }
        if (template != null) {
            if (template == extend) {
                throw new IllegalStateException("The template " + template.getName() + " can not be recursive extending the self template.");
            }
            Context.getContext().putAll((Map<? extends String, ? extends Object>)template.getMacros());
        }
        return extend;
    }

    public Template $extends(String name, Map<String, Object> parameters) throws IOException, ParseException {
        return this.$extends(name, null, null, parameters);
    }

    public Template $extends(String name, String encoding, Map<String, Object> parameters) throws IOException, ParseException {
        return this.$extends(name, null, encoding, parameters);
    }

    public Template $extends(String name, Locale locale, Map<String, Object> parameters) throws IOException, ParseException {
        return this.$extends(name, locale, null, parameters);
    }

    public Template $extends(String name, Locale locale, String encoding, Map<String, Object> parameters) throws IOException, ParseException {
        if (parameters != null) {
            Context.getContext().putAll((Map<? extends String, ? extends Object>)parameters);
        }
        return this.$extends(name, locale, encoding);
    }

    public Template render(Resource resource) throws IOException, ParseException {
        return this.render(IOUtils.readToString(resource.openReader()));
    }

    public Template render(byte[] source) throws IOException, ParseException {
        Template template = Context.getContext().getTemplate();
        if (template == null) {
            throw new IllegalArgumentException("display context template == null");
        }
        String encoding = template.getEncoding();
        return this.render(encoding == null ? new String(source) : new String(source, encoding));
    }

    public Template render(char[] source) throws IOException, ParseException {
        return this.render(new String(source));
    }

    public Template render(String source) throws IOException, ParseException {
        Template template = Context.getContext().getTemplate();
        if (template == null) {
            throw new IllegalArgumentException("display context template == null");
        }
        return this.engine.parseTemplate(source);
    }

    public Template include(String name) throws IOException, ParseException {
        return this.include(name, (Locale)null, (String)null);
    }

    public Template include(String name, String encoding) throws IOException, ParseException {
        return this.include(name, (Locale)null, encoding);
    }

    public Template include(String name, Locale locale) throws IOException, ParseException {
        return this.include(name, locale, (String)null);
    }

    public Template include(String name, Locale locale, String encoding) throws IOException, ParseException {
        Template template;
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("include template name == null");
        }
        String macro = null;
        int i = name.indexOf(35);
        if (i > 0) {
            macro = name.substring(i + 1);
            name = name.substring(0, i);
        }
        if ((template = Context.getContext().getTemplate()) != null) {
            if (StringUtils.isEmpty(encoding)) {
                encoding = template.getEncoding();
            }
            name = UrlUtils.relativeUrl(name, template.getName());
            if (locale == null) {
                locale = template.getLocale();
            }
        }
        Template include = this.engine.getTemplate(name, locale, encoding);
        if (StringUtils.isNotEmpty(macro)) {
            include = include.getMacros().get(macro);
        }
        if (template != null && template == include) {
            throw new IllegalStateException("The template " + template.getName() + " can not be recursive including the self template.");
        }
        return include;
    }

    public Template include(String name, Map<String, Object> parameters) throws IOException, ParseException {
        return this.include(name, null, null, parameters);
    }

    public Template include(String name, String encoding, Map<String, Object> parameters) throws IOException, ParseException {
        return this.include(name, null, encoding, parameters);
    }

    public Template include(String name, Locale locale, Map<String, Object> parameters) throws IOException, ParseException {
        return this.include(name, locale, null, parameters);
    }

    public Template include(String name, Locale locale, String encoding, Map<String, Object> parameters) throws IOException, ParseException {
        if (parameters != null) {
            Context.getContext().putAll((Map<? extends String, ? extends Object>)parameters);
        }
        return this.include(name, locale, encoding);
    }

    public Resource read(String name) throws IOException, ParseException {
        return this.read(name, null, null);
    }

    public Resource read(String name, String encoding) throws IOException {
        return this.read(name, null, encoding);
    }

    public Resource read(String name, Locale locale) throws IOException {
        return this.read(name, locale, null);
    }

    public Resource read(String name, Locale locale, String encoding) throws IOException {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("display template name == null");
        }
        Template template = Context.getContext().getTemplate();
        if (template != null) {
            if (StringUtils.isEmpty(encoding)) {
                encoding = template.getEncoding();
            }
            name = UrlUtils.relativeUrl(name, template.getName());
            if (locale == null) {
                locale = template.getLocale();
            }
        }
        return this.engine.getResource(name, locale, encoding);
    }
}

