/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.methods.cycles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCycle<T> {
    private final T[] values;
    private final int size;
    private int index;

    public ArrayCycle(T[] values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("cycle values == null");
        }
        this.values = values;
        this.size = values.length;
        this.index = -1;
    }

    public Object getNext() {
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
        return this.values[this.index];
    }

    public Object getValue() {
        if (this.index == -1) {
            return this.values[0];
        }
        return this.values[this.index];
    }

    public T[] getValues() {
        return this.values;
    }

    public int getSize() {
        return this.size;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return String.valueOf(this.getNext());
    }
}

