/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.methods.cycles;

public class LongArrayCycle {
    private final long[] values;
    private final int size;
    private int index;

    public LongArrayCycle(long[] values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("cycle values == null");
        }
        this.values = values;
        this.size = values.length;
        this.index = -1;
    }

    public long getNext() {
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
        return this.values[this.index];
    }

    public long getValue() {
        if (this.index == -1) {
            return this.values[0];
        }
        return this.values[this.index];
    }

    public long[] getValues() {
        return this.values;
    }

    public int getSize() {
        return this.size;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return String.valueOf(this.getNext());
    }
}

