/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.resolvers;

import httl.spi.Resolver;
import java.util.HashMap;
import java.util.Map;

public class MultiResolver
implements Resolver {
    private Resolver[] resolvers;
    private Map<String, Resolver> resolverMap;

    public void setResolvers(Resolver[] resolvers) {
        this.resolvers = resolvers;
        this.resolverMap = new HashMap<String, Resolver>();
        String suffix = Resolver.class.getSimpleName();
        for (Resolver resolver : resolvers) {
            String name = resolver.getClass().getSimpleName();
            if (name.endsWith(suffix)) {
                name = name.substring(0, name.length() - suffix.length());
            }
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
            this.resolverMap.put(name, resolver);
        }
    }

    public Object get(String key) {
        if (this.resolvers == null || this.resolvers.length == 0) {
            return null;
        }
        for (Resolver resolver : this.resolvers) {
            Object value = resolver.get(key);
            if (value == null) continue;
            return value;
        }
        if (this.resolverMap != null) {
            return this.resolverMap.get(key);
        }
        return null;
    }
}

