/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators.templates;

import httl.Context;
import httl.Engine;
import httl.Node;
import httl.Template;
import httl.Visitor;
import httl.util.UnsafeByteArrayOutputStream;
import httl.util.UnsafeStringWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyTemplate
implements Template {
    private final Template template;

    public ProxyTemplate(Template template) {
        this.template = template;
    }

    @Override
    public Object evaluate() throws ParseException {
        return this.evaluate(null);
    }

    @Override
    public Object evaluate(Object parameters) throws ParseException {
        if (Context.getContext().getOut() instanceof OutputStream) {
            UnsafeByteArrayOutputStream output = new UnsafeByteArrayOutputStream();
            try {
                this.render(parameters, output);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return output.toByteArray();
        }
        UnsafeStringWriter writer = new UnsafeStringWriter();
        try {
            this.render(parameters, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return writer.toString();
    }

    @Override
    public void render() throws IOException, ParseException {
        this.render(null, Context.getContext().getOut());
    }

    @Override
    public void render(Object stream) throws IOException, ParseException {
        this.render(null, stream);
    }

    @Override
    public void render(Object parameters, Object stream) throws IOException, ParseException {
        this.template.render(parameters, stream);
    }

    @Override
    public String getName() {
        return this.template.getName();
    }

    @Override
    public String getEncoding() {
        return this.template.getEncoding();
    }

    @Override
    public Locale getLocale() {
        return this.template.getLocale();
    }

    @Override
    public long getLastModified() {
        return this.template.getLastModified();
    }

    @Override
    public long getLength() {
        return this.template.getLength();
    }

    @Override
    public String getSource() throws IOException {
        return this.template.getSource();
    }

    @Override
    public Reader openReader() throws IOException {
        return this.template.openReader();
    }

    @Override
    public Map<String, Class<?>> getVariables() {
        return this.template.getVariables();
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.template.openStream();
    }

    @Override
    public int getOffset() {
        return this.template.getOffset();
    }

    @Override
    public Engine getEngine() {
        return this.template.getEngine();
    }

    @Override
    public Map<String, Template> getMacros() {
        return this.template.getMacros();
    }

    @Override
    public boolean isMacro() {
        return this.template.isMacro();
    }

    @Override
    public void accept(Visitor visitor) throws IOException, ParseException {
        this.template.accept(visitor);
    }

    @Override
    public Template getParent() {
        return this.template.getParent();
    }

    @Override
    public List<Node> getChildren() {
        return this.template.getChildren();
    }
}

