/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators.templates;

import httl.ast.AstVisitor;
import httl.ast.SetDirective;
import httl.ast.Variable;
import httl.util.OrderedMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableVisitor
extends AstVisitor {
    private Class<?> defaultVariableType = Object.class;
    private boolean addDefault;
    private final List<String> variableNames = new ArrayList<String>();
    private final List<Class<?>> variableTypes = new ArrayList();

    public VariableVisitor(Class<?> defaultVariableType, boolean addDefault) {
        this.defaultVariableType = defaultVariableType;
        this.addDefault = addDefault;
    }

    public Map<String, Class<?>> getVariables() {
        return new OrderedMap(this.variableNames.toArray(new String[this.variableNames.size()]), this.variableTypes.toArray(new Class[this.variableTypes.size()]));
    }

    @Override
    public void visit(SetDirective node) throws ParseException {
        if (node.getExpression() == null) {
            int i;
            Type type = node.getType();
            Class<?> clazz = (Class<?>)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
            if (clazz == null) {
                if (this.addDefault) {
                    clazz = this.defaultVariableType;
                } else {
                    return;
                }
            }
            if ((i = this.variableNames.indexOf(node.getName())) >= 0) {
                Class<?> cls = this.variableTypes.get(i);
                if (!(cls.equals(clazz) || cls.isAssignableFrom(clazz) || clazz.isAssignableFrom(cls))) {
                    throw new ParseException("Defined different type variable " + node.getName() + ", conflict types: " + cls + ", " + clazz, node.getOffset());
                }
            } else {
                this.variableNames.add(node.getName());
                this.variableTypes.add(clazz);
            }
        }
    }

    @Override
    public void visit(Variable node) throws ParseException {
        if (this.addDefault && !this.variableNames.contains(node.getName())) {
            this.variableNames.add(node.getName());
            this.variableTypes.add(this.defaultVariableType);
        }
    }
}

