/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLinkedHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int MAXIMUM_BUFFER_SIZE = 0x100000;
    static final int BUFFER_THRESHOLD = 16;
    static final int NUMBER_OF_BUFFERS;
    static final int BUFFER_MASK;
    static final int AMORTIZED_DRAIN_THRESHOLD;
    static final Queue<?> DISCARDING_QUEUE;
    final ConcurrentMap<K, Node> data;
    final int concurrencyLevel;
    final LinkedDeque<Node> evictionDeque;
    final AtomicLong weightedSize;
    volatile long capacity;
    volatile int nextOrder;
    int drainedOrder;
    final Task[] tasks;
    final Lock evictionLock;
    final Queue<Task>[] buffers;
    final AtomicIntegerArray bufferLengths;
    final AtomicReference<DrainStatus> drainStatus;
    final EntryWeigher<? super K, ? super V> weigher;
    final Queue<Node> pendingNotifications;
    final EvictionListener<K, V> listener;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public ConcurrentLinkedHashMap() {
        this(9223372034707292160L);
    }

    public ConcurrentLinkedHashMap(long capacity) {
        this(new Builder().maximumWeightedCapacity(capacity));
    }

    private ConcurrentLinkedHashMap(Builder<K, V> builder) {
        ConcurrentLinkedHashMap.checkState(this.capacity >= 0L);
        this.concurrencyLevel = builder.concurrencyLevel;
        this.capacity = Math.min(builder.capacity, 9223372034707292160L);
        this.data = new ConcurrentHashMap<K, Node>(builder.initialCapacity, 0.75f, this.concurrencyLevel);
        this.weigher = builder.weigher;
        this.nextOrder = Integer.MIN_VALUE;
        this.weightedSize = new AtomicLong();
        this.drainedOrder = Integer.MIN_VALUE;
        this.evictionLock = new ReentrantLock();
        this.evictionDeque = new LinkedDeque();
        this.drainStatus = new AtomicReference<DrainStatus>(DrainStatus.IDLE);
        this.bufferLengths = new AtomicIntegerArray(NUMBER_OF_BUFFERS);
        this.buffers = new Queue[NUMBER_OF_BUFFERS];
        for (int i = 0; i < NUMBER_OF_BUFFERS; ++i) {
            this.buffers[i] = new ConcurrentLinkedQueue<Task>();
        }
        this.tasks = new Task[AMORTIZED_DRAIN_THRESHOLD];
        this.listener = builder.listener;
        this.pendingNotifications = this.listener == DiscardingListener.INSTANCE ? DISCARDING_QUEUE : new ConcurrentLinkedQueue();
    }

    static void checkNotNull(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public long capacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        ConcurrentLinkedHashMap.checkArgument(capacity >= 0L);
        this.evictionLock.lock();
        try {
            this.capacity = Math.min(capacity, 9223372034707292160L);
            this.drainBuffers();
            this.evict();
        }
        finally {
            this.evictionLock.unlock();
        }
        this.notifyListener();
    }

    boolean hasOverflowed() {
        return this.weightedSize.get() > this.capacity;
    }

    void evict() {
        while (this.hasOverflowed()) {
            Node node = (Node)this.evictionDeque.poll();
            if (node == null) {
                return;
            }
            if (this.data.remove(node.key, node)) {
                this.pendingNotifications.add(node);
            }
            node.makeDead();
        }
    }

    void afterCompletion(Task task) {
        boolean delayable = this.schedule(task);
        DrainStatus status = this.drainStatus.get();
        if (status.shouldDrainBuffers(delayable)) {
            this.tryToDrainBuffers();
        }
        this.notifyListener();
    }

    boolean schedule(Task task) {
        int index = ConcurrentLinkedHashMap.bufferIndex();
        int buffered = this.bufferLengths.incrementAndGet(index);
        if (task.isWrite()) {
            this.buffers[index].add(task);
            this.drainStatus.set(DrainStatus.REQUIRED);
            return false;
        }
        if (buffered <= 0x100000) {
            this.buffers[index].add(task);
            return buffered <= 16;
        }
        this.bufferLengths.decrementAndGet(index);
        return false;
    }

    static int bufferIndex() {
        return (int)Thread.currentThread().getId() & BUFFER_MASK;
    }

    int nextOrdering() {
        return this.nextOrder++;
    }

    void tryToDrainBuffers() {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.set(DrainStatus.PROCESSING);
                this.drainBuffers();
            }
            finally {
                this.drainStatus.compareAndSet(DrainStatus.PROCESSING, DrainStatus.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    void drainBuffers() {
        int maxTaskIndex = this.moveTasksFromBuffers(this.tasks);
        this.updateDrainedOrder(this.tasks, maxTaskIndex);
        this.runTasks(this.tasks, maxTaskIndex);
    }

    int moveTasksFromBuffers(Task[] tasks) {
        int maxTaskIndex = -1;
        for (int i = 0; i < this.buffers.length; ++i) {
            int maxIndex = this.moveTasksFromBuffer(tasks, i);
            maxTaskIndex = Math.max(maxIndex, maxTaskIndex);
        }
        return maxTaskIndex;
    }

    int moveTasksFromBuffer(Task[] tasks, int bufferIndex) {
        Task task;
        Queue<Task> buffer = this.buffers[bufferIndex];
        int removedFromBuffer = 0;
        int maxIndex = -1;
        while ((task = buffer.poll()) != null) {
            ++removedFromBuffer;
            int index = task.getOrder() - this.drainedOrder;
            if (index < 0) {
                task.run();
                continue;
            }
            if (index >= tasks.length) {
                maxIndex = tasks.length - 1;
                this.addTaskToChain(tasks, task, maxIndex);
                break;
            }
            maxIndex = Math.max(index, maxIndex);
            this.addTaskToChain(tasks, task, index);
        }
        this.bufferLengths.addAndGet(bufferIndex, -removedFromBuffer);
        return maxIndex;
    }

    void addTaskToChain(Task[] tasks, Task task, int index) {
        task.setNext(tasks[index]);
        tasks[index] = task;
    }

    void runTasks(Task[] tasks, int maxTaskIndex) {
        for (int i = 0; i <= maxTaskIndex; ++i) {
            this.runTasksInChain(tasks[i]);
            tasks[i] = null;
        }
    }

    void runTasksInChain(Task task) {
        while (task != null) {
            Task current = task;
            task = task.getNext();
            current.setNext(null);
            current.run();
        }
    }

    void updateDrainedOrder(Task[] tasks, int maxTaskIndex) {
        if (maxTaskIndex >= 0) {
            Task task = tasks[maxTaskIndex];
            this.drainedOrder = task.getOrder() + 1;
        }
    }

    void notifyListener() {
        Node node;
        while ((node = this.pendingNotifications.poll()) != null) {
            this.listener.onEviction(node.key, node.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public long weightedSize() {
        return Math.max(0L, this.weightedSize.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            Node node;
            while ((node = (Node)this.evictionDeque.poll()) != null) {
                this.data.remove(node.key, node);
                node.makeDead();
            }
            for (int i = 0; i < this.buffers.length; ++i) {
                Task task;
                Queue<Task> buffer = this.buffers[i];
                int removed = 0;
                while ((task = buffer.poll()) != null) {
                    if (task.isWrite()) {
                        task.run();
                    }
                    ++removed;
                }
                this.bufferLengths.addAndGet(i, -removed);
            }
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        ConcurrentLinkedHashMap.checkNotNull(value);
        for (Node node : this.data.values()) {
            if (!node.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Node node = (Node)this.data.get(key);
        if (node == null) {
            return null;
        }
        this.afterCompletion(new ReadTask(node));
        return node.getValue();
    }

    public V getQuietly(Object key) {
        Node node = (Node)this.data.get(key);
        return node == null ? null : (V)node.getValue();
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.put(key, value, true);
    }

    V put(K key, V value, boolean onlyIfAbsent) {
        WeightedValue oldWeightedValue;
        Node prior;
        ConcurrentLinkedHashMap.checkNotNull(key);
        ConcurrentLinkedHashMap.checkNotNull(value);
        int weight = this.weigher.weightOf(key, value);
        WeightedValue<V> weightedValue = new WeightedValue<V>(value, weight);
        Node node = new Node(key, weightedValue);
        block0: while (true) {
            if ((prior = this.data.putIfAbsent(node.key, node)) == null) {
                this.afterCompletion(new AddTask(node, weight));
                return null;
            }
            if (onlyIfAbsent) {
                this.afterCompletion(new ReadTask(prior));
                return prior.getValue();
            }
            do {
                if (!(oldWeightedValue = (WeightedValue)prior.get()).isAlive()) continue block0;
            } while (!prior.compareAndSet(oldWeightedValue, weightedValue));
            break;
        }
        int weightedDifference = weight - oldWeightedValue.weight;
        ReadTask task = weightedDifference == 0 ? new ReadTask(prior) : new UpdateTask(prior, weightedDifference);
        this.afterCompletion(task);
        return oldWeightedValue.value;
    }

    @Override
    public V remove(Object key) {
        Node node = (Node)this.data.remove(key);
        if (node == null) {
            return null;
        }
        node.makeRetired();
        this.afterCompletion(new RemovalTask(node));
        return node.getValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        Node node = (Node)this.data.get(key);
        if (node == null || value == null) {
            return false;
        }
        WeightedValue weightedValue = (WeightedValue)node.get();
        while (weightedValue.contains(value)) {
            if (node.tryToRetire(weightedValue)) {
                if (!this.data.remove(key, node)) break;
                this.afterCompletion(new RemovalTask(node));
                return true;
            }
            weightedValue = (WeightedValue)node.get();
            if (weightedValue.isAlive()) continue;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        WeightedValue oldWeightedValue;
        ConcurrentLinkedHashMap.checkNotNull(key);
        ConcurrentLinkedHashMap.checkNotNull(value);
        int weight = this.weigher.weightOf(key, value);
        WeightedValue<V> weightedValue = new WeightedValue<V>(value, weight);
        Node node = (Node)this.data.get(key);
        if (node == null) {
            return null;
        }
        do {
            if ((oldWeightedValue = (WeightedValue)node.get()).isAlive()) continue;
            return null;
        } while (!node.compareAndSet(oldWeightedValue, weightedValue));
        int weightedDifference = weight - oldWeightedValue.weight;
        ReadTask task = weightedDifference == 0 ? new ReadTask(node) : new UpdateTask(node, weightedDifference);
        this.afterCompletion(task);
        return oldWeightedValue.value;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        WeightedValue weightedValue;
        ConcurrentLinkedHashMap.checkNotNull(key);
        ConcurrentLinkedHashMap.checkNotNull(oldValue);
        ConcurrentLinkedHashMap.checkNotNull(newValue);
        int weight = this.weigher.weightOf(key, newValue);
        WeightedValue<V> newWeightedValue = new WeightedValue<V>(newValue, weight);
        Node node = (Node)this.data.get(key);
        if (node == null) {
            return false;
        }
        do {
            if ((weightedValue = (WeightedValue)node.get()).isAlive() && weightedValue.contains(oldValue)) continue;
            return false;
        } while (!node.compareAndSet(weightedValue, newWeightedValue));
        int weightedDifference = weight - weightedValue.weight;
        ReadTask task = weightedDifference == 0 ? new ReadTask(node) : new UpdateTask(node, weightedDifference);
        this.afterCompletion(task);
        return true;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks == null ? (this.keySet = new KeySet()) : ks;
    }

    public Set<K> ascendingKeySet() {
        return this.ascendingKeySetWithLimit(Integer.MAX_VALUE);
    }

    public Set<K> ascendingKeySetWithLimit(int limit) {
        return this.orderedKeySet(true, limit);
    }

    public Set<K> descendingKeySet() {
        return this.descendingKeySetWithLimit(Integer.MAX_VALUE);
    }

    public Set<K> descendingKeySetWithLimit(int limit) {
        return this.orderedKeySet(false, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<K> orderedKeySet(boolean ascending, int limit) {
        ConcurrentLinkedHashMap.checkArgument(limit >= 0);
        this.evictionLock.lock();
        try {
            Iterator<Node> iterator;
            this.drainBuffers();
            int initialCapacity = this.weigher == Weighers.entrySingleton() ? Math.min(limit, (int)this.weightedSize()) : 16;
            LinkedHashSet keys = new LinkedHashSet(initialCapacity);
            Iterator<Node> iterator2 = iterator = ascending ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (iterator.hasNext() && limit > keys.size()) {
                keys.add(iterator.next().key);
            }
            Set set = Collections.unmodifiableSet(keys);
            return set;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs == null ? (this.values = new Values()) : vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    public Map<K, V> ascendingMap() {
        return this.ascendingMapWithLimit(Integer.MAX_VALUE);
    }

    public Map<K, V> ascendingMapWithLimit(int limit) {
        return this.orderedMap(true, limit);
    }

    public Map<K, V> descendingMap() {
        return this.descendingMapWithLimit(Integer.MAX_VALUE);
    }

    public Map<K, V> descendingMapWithLimit(int limit) {
        return this.orderedMap(false, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> orderedMap(boolean ascending, int limit) {
        ConcurrentLinkedHashMap.checkArgument(limit >= 0);
        this.evictionLock.lock();
        try {
            Iterator<Node> iterator;
            this.drainBuffers();
            int initialCapacity = this.weigher == Weighers.entrySingleton() ? Math.min(limit, (int)this.weightedSize()) : 16;
            LinkedHashMap map = new LinkedHashMap(initialCapacity);
            Iterator<Node> iterator2 = iterator = ascending ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (iterator.hasNext() && limit > map.size()) {
                Node node = iterator.next();
                map.put(node.key, node.getValue());
            }
            Map map2 = Collections.unmodifiableMap(map);
            return map2;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static {
        DISCARDING_QUEUE = new DiscardingQueue();
        NUMBER_OF_BUFFERS = ConcurrentLinkedHashMap.ceilingNextPowerOfTwo(Runtime.getRuntime().availableProcessors());
        AMORTIZED_DRAIN_THRESHOLD = (1 + NUMBER_OF_BUFFERS) * 16;
        BUFFER_MASK = NUMBER_OF_BUFFERS - 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Weighers {
        private Weighers() {
            throw new AssertionError();
        }

        public static <K, V> EntryWeigher<K, V> asEntryWeigher(Weigher<? super V> weigher) {
            return weigher == Weighers.singleton() ? Weighers.entrySingleton() : new EntryWeigherView(weigher);
        }

        public static <K, V> EntryWeigher<K, V> entrySingleton() {
            return SingletonEntryWeigher.INSTANCE;
        }

        public static <V> Weigher<V> singleton() {
            return SingletonWeigher.INSTANCE;
        }

        public static Weigher<byte[]> byteArray() {
            return ByteArrayWeigher.INSTANCE;
        }

        public static <E> Weigher<? super Iterable<E>> iterable() {
            return IterableWeigher.INSTANCE;
        }

        public static <E> Weigher<? super Collection<E>> collection() {
            return CollectionWeigher.INSTANCE;
        }

        public static <E> Weigher<? super List<E>> list() {
            return ListWeigher.INSTANCE;
        }

        public static <E> Weigher<? super Set<E>> set() {
            return SetWeigher.INSTANCE;
        }

        public static <A, B> Weigher<? super Map<A, B>> map() {
            return MapWeigher.INSTANCE;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum MapWeigher implements Weigher<Map<?, ?>>
        {
            INSTANCE;


            @Override
            public int weightOf(Map<?, ?> values) {
                return values.size();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum SetWeigher implements Weigher<Set<?>>
        {
            INSTANCE;


            @Override
            public int weightOf(Set<?> values) {
                return values.size();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum ListWeigher implements Weigher<List<?>>
        {
            INSTANCE;


            @Override
            public int weightOf(List<?> values) {
                return values.size();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum CollectionWeigher implements Weigher<Collection<?>>
        {
            INSTANCE;


            @Override
            public int weightOf(Collection<?> values) {
                return values.size();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum IterableWeigher implements Weigher<Iterable<?>>
        {
            INSTANCE;


            @Override
            public int weightOf(Iterable<?> values) {
                if (values instanceof Collection) {
                    return ((Collection)values).size();
                }
                int size = 0;
                Iterator<?> i = values.iterator();
                while (i.hasNext()) {
                    i.next();
                    ++size;
                }
                return size;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum ByteArrayWeigher implements Weigher<byte[]>
        {
            INSTANCE;


            @Override
            public int weightOf(byte[] value) {
                return value.length;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum SingletonWeigher implements Weigher<Object>
        {
            INSTANCE;


            @Override
            public int weightOf(Object value) {
                return 1;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum SingletonEntryWeigher implements EntryWeigher<Object, Object>
        {
            INSTANCE;


            @Override
            public int weightOf(Object key, Object value) {
                return 1;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class EntryWeigherView<K, V>
        implements EntryWeigher<K, V>,
        Serializable {
            static final long serialVersionUID = 1L;
            final Weigher<? super V> weigher;

            EntryWeigherView(Weigher<? super V> weigher) {
                ConcurrentLinkedHashMap.checkNotNull(weigher);
                this.weigher = weigher;
            }

            @Override
            public int weightOf(K key, V value) {
                return this.weigher.weightOf(value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Weigher<V> {
        public int weightOf(V var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface EvictionListener<K, V> {
        public void onEviction(K var1, V var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface EntryWeigher<K, V> {
        public int weightOf(K var1, V var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Linked<T extends Linked<T>> {
        public T getPrevious();

        public void setPrevious(T var1);

        public T getNext();

        public void setNext(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LinkedDeque<E extends Linked<E>>
    extends AbstractCollection<E>
    implements Queue<E>,
    Serializable {
        private static final long serialVersionUID = 1L;
        E first;
        E last;

        LinkedDeque() {
        }

        void linkFirst(E e) {
            E f = this.first;
            this.first = e;
            if (f == null) {
                this.last = e;
            } else {
                f.setPrevious(e);
                e.setNext(f);
            }
        }

        void linkLast(E e) {
            E l = this.last;
            this.last = e;
            if (l == null) {
                this.first = e;
            } else {
                l.setNext(e);
                e.setPrevious(l);
            }
        }

        E unlinkFirst() {
            E f = this.first;
            Object next = f.getNext();
            f.setNext(null);
            this.first = next;
            if (next == null) {
                this.last = null;
            } else {
                next.setPrevious(null);
            }
            return f;
        }

        E unlinkLast() {
            E l = this.last;
            Object prev = l.getPrevious();
            l.setPrevious(null);
            this.last = prev;
            if (prev == null) {
                this.first = null;
            } else {
                prev.setNext(null);
            }
            return l;
        }

        void unlink(E e) {
            Object prev = e.getPrevious();
            Object next = e.getNext();
            if (prev == null) {
                this.first = next;
            } else {
                prev.setNext(next);
                e.setPrevious(null);
            }
            if (next == null) {
                this.last = prev;
            } else {
                next.setPrevious(prev);
                e.setNext(null);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.first == null;
        }

        void checkNotEmpty() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int size() {
            int size = 0;
            for (Object e = this.first; e != null; e = e.getNext()) {
                ++size;
            }
            return size;
        }

        @Override
        public void clear() {
            Object e = this.first;
            while (e != null) {
                Object next = e.getNext();
                e.setPrevious(null);
                e.setNext(null);
                e = next;
            }
            this.last = null;
            this.first = null;
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof Linked && this.contains((Linked)o);
        }

        boolean contains(Linked<?> e) {
            return e.getPrevious() != null || e.getNext() != null || e == this.first;
        }

        public void moveToFront(E e) {
            if (e != this.first) {
                this.unlink(e);
                this.linkFirst(e);
            }
        }

        public void moveToBack(E e) {
            if (e != this.last) {
                this.unlink(e);
                this.linkLast(e);
            }
        }

        @Override
        public E peek() {
            return this.peekFirst();
        }

        public E peekFirst() {
            return this.first;
        }

        public E peekLast() {
            return this.last;
        }

        public E getFirst() {
            this.checkNotEmpty();
            return this.peekFirst();
        }

        public E getLast() {
            this.checkNotEmpty();
            return this.peekLast();
        }

        @Override
        public E element() {
            return this.getFirst();
        }

        @Override
        public boolean offer(E e) {
            return this.offerLast(e);
        }

        public boolean offerFirst(E e) {
            if (this.contains((Linked<?>)e)) {
                return false;
            }
            this.linkFirst(e);
            return true;
        }

        public boolean offerLast(E e) {
            if (this.contains((Linked<?>)e)) {
                return false;
            }
            this.linkLast(e);
            return true;
        }

        @Override
        public boolean add(E e) {
            return this.offerLast(e);
        }

        public void addFirst(E e) {
            if (!this.offerFirst(e)) {
                throw new IllegalArgumentException();
            }
        }

        public void addLast(E e) {
            if (!this.offerLast(e)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public E poll() {
            return this.pollFirst();
        }

        public E pollFirst() {
            return this.isEmpty() ? null : (E)this.unlinkFirst();
        }

        public E pollLast() {
            return this.isEmpty() ? null : (E)this.unlinkLast();
        }

        @Override
        public E remove() {
            return this.removeFirst();
        }

        @Override
        public boolean remove(Object o) {
            return o instanceof Linked && this.remove((E)((Linked)o));
        }

        @Override
        boolean remove(E e) {
            if (this.contains((Linked<?>)e)) {
                this.unlink(e);
                return true;
            }
            return false;
        }

        public E removeFirst() {
            this.checkNotEmpty();
            return this.pollFirst();
        }

        public boolean removeFirstOccurrence(Object o) {
            return this.remove(o);
        }

        public E removeLast() {
            this.checkNotEmpty();
            return this.pollLast();
        }

        public boolean removeLastOccurrence(Object o) {
            return this.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            for (Object o : c) {
                modified |= this.remove(o);
            }
            return modified;
        }

        public void push(E e) {
            this.addFirst(e);
        }

        public E pop() {
            return this.removeFirst();
        }

        @Override
        public Iterator<E> iterator() {
            return new AbstractLinkedIterator((Linked)this.first){

                @Override
                E computeNext() {
                    return this.cursor.getNext();
                }
            };
        }

        public Iterator<E> descendingIterator() {
            return new AbstractLinkedIterator((Linked)this.last){

                @Override
                E computeNext() {
                    return this.cursor.getPrevious();
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static abstract class AbstractLinkedIterator
        implements Iterator<E> {
            E cursor;
            final /* synthetic */ LinkedDeque this$0;

            AbstractLinkedIterator(E start) {
                this.this$0 = this$0;
                this.cursor = start;
            }

            @Override
            public boolean hasNext() {
                return this.cursor != null;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object e = this.cursor;
                this.cursor = this.computeNext();
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            abstract E computeNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Builder<K, V> {
        static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        EvictionListener<K, V> listener;
        EntryWeigher<? super K, ? super V> weigher = Weighers.entrySingleton();
        int concurrencyLevel = 16;
        int initialCapacity = 16;
        long capacity = -1L;

        public Builder() {
            this.listener = DiscardingListener.INSTANCE;
        }

        public Builder<K, V> initialCapacity(int initialCapacity) {
            ConcurrentLinkedHashMap.checkArgument(initialCapacity >= 0);
            this.initialCapacity = initialCapacity;
            return this;
        }

        public Builder<K, V> maximumWeightedCapacity(long capacity) {
            ConcurrentLinkedHashMap.checkArgument(capacity >= 0L);
            this.capacity = capacity;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int concurrencyLevel) {
            ConcurrentLinkedHashMap.checkArgument(concurrencyLevel > 0);
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<K, V> listener(EvictionListener<K, V> listener) {
            ConcurrentLinkedHashMap.checkNotNull(listener);
            this.listener = listener;
            return this;
        }

        public Builder<K, V> weigher(Weigher<? super V> weigher) {
            this.weigher = weigher == Weighers.singleton() ? Weighers.entrySingleton() : new BoundedEntryWeigher(Weighers.asEntryWeigher(weigher));
            return this;
        }

        public Builder<K, V> weigher(EntryWeigher<? super K, ? super V> weigher) {
            this.weigher = weigher == Weighers.entrySingleton() ? Weighers.entrySingleton() : new BoundedEntryWeigher<K, V>(weigher);
            return this;
        }

        public ConcurrentLinkedHashMap<K, V> build() {
            ConcurrentLinkedHashMap.checkState(this.capacity >= 0L);
            return new ConcurrentLinkedHashMap(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SerializationProxy<K, V>
    implements Serializable {
        final EntryWeigher<? super K, ? super V> weigher;
        final EvictionListener<K, V> listener;
        final int concurrencyLevel;
        final Map<K, V> data;
        final long capacity;
        static final long serialVersionUID = 1L;

        SerializationProxy(ConcurrentLinkedHashMap<K, V> map) {
            this.concurrencyLevel = map.concurrencyLevel;
            this.data = new HashMap<K, V>(map);
            this.capacity = map.capacity;
            this.listener = map.listener;
            this.weigher = map.weigher;
        }

        Object readResolve() {
            ConcurrentLinkedHashMap<K, V> map = new Builder().concurrencyLevel(this.concurrencyLevel).maximumWeightedCapacity(this.capacity).listener(this.listener).weigher(this.weigher).build();
            map.putAll(this.data);
            return map;
        }
    }

    abstract class AbstractTask
    implements Task {
        final int order;
        Task task;

        AbstractTask() {
            this.order = ConcurrentLinkedHashMap.this.nextOrdering();
        }

        public int getOrder() {
            return this.order;
        }

        public Task getNext() {
            return this.task;
        }

        public void setNext(Task task) {
            this.task = task;
        }
    }

    static interface Task
    extends Runnable {
        public int getOrder();

        public boolean isWrite();

        public Task getNext();

        public void setNext(Task var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DiscardingListener implements EvictionListener<Object, Object>
    {
        INSTANCE;


        @Override
        public void onEviction(Object key, Object value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DiscardingQueue
    extends AbstractQueue<Object> {
        DiscardingQueue() {
        }

        @Override
        public boolean add(Object e) {
            return true;
        }

        @Override
        public boolean offer(Object e) {
            return true;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BoundedEntryWeigher<K, V>
    implements EntryWeigher<K, V>,
    Serializable {
        static final long serialVersionUID = 1L;
        final EntryWeigher<? super K, ? super V> weigher;

        BoundedEntryWeigher(EntryWeigher<? super K, ? super V> weigher) {
            ConcurrentLinkedHashMap.checkNotNull(weigher);
            this.weigher = weigher;
        }

        @Override
        public int weightOf(K key, V value) {
            int weight = this.weigher.weightOf(key, value);
            ConcurrentLinkedHashMap.checkArgument(weight >= 1);
            return weight;
        }

        Object writeReplace() {
            return this.weigher;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class WriteThroughEntry
    implements Map.Entry<K, V> {
        static final long serialVersionUID = 1L;
        private final K key;
        private V value;

        WriteThroughEntry(Node node) {
            this.key = node.key;
            this.value = node.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            ConcurrentLinkedHashMap.this.put(this.getKey(), value);
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        private ConcurrentLinkedHashMap<K, V> getOuterType() {
            return ConcurrentLinkedHashMap.this;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WriteThroughEntry other = (WriteThroughEntry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Node> iterator;
        Node current;

        EntryIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iterator.next();
            return new WriteThroughEntry(this.current);
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final ConcurrentLinkedHashMap<K, V> map;

        EntrySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Node node = (Node)this.map.data.get(entry.getKey());
            return node != null && node.getValue().equals(entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.map.putIfAbsent(entry.getKey(), entry.getValue()) == null;
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.map.remove(entry.getKey(), entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    implements Iterator<V> {
        final Iterator<Node> iterator;
        Node current;

        ValueIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            this.current = this.iterator.next();
            return this.current.getValue();
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public int size() {
            return ConcurrentLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentLinkedHashMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentLinkedHashMap.this.containsValue(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    implements Iterator<K> {
        final Iterator<K> iterator;
        K current;

        KeyIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<K> {
        final ConcurrentLinkedHashMap<K, V> map;

        KeySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object obj) {
            return ConcurrentLinkedHashMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return this.map.remove(obj) != null;
        }

        @Override
        public Object[] toArray() {
            return this.map.data.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.map.data.keySet().toArray(array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Node
    extends AtomicReference<WeightedValue<V>>
    implements Linked<Node> {
        final K key;
        Node prev;
        Node next;

        Node(K key, WeightedValue<V> weightedValue) {
            super(weightedValue);
            this.key = key;
        }

        @Override
        public Node getPrevious() {
            return this.prev;
        }

        @Override
        public void setPrevious(Node prev) {
            this.prev = prev;
        }

        @Override
        public Node getNext() {
            return this.next;
        }

        @Override
        public void setNext(Node next) {
            this.next = next;
        }

        V getValue() {
            return ((WeightedValue)this.get()).value;
        }

        boolean tryToRetire(WeightedValue<V> expect) {
            if (expect.isAlive()) {
                WeightedValue retired = new WeightedValue(expect.value, -expect.weight);
                return this.compareAndSet(expect, retired);
            }
            return false;
        }

        void makeRetired() {
            WeightedValue retired;
            WeightedValue current;
            do {
                if ((current = (WeightedValue)this.get()).isAlive()) continue;
                return;
            } while (!this.compareAndSet(current, retired = new WeightedValue(current.value, -current.weight)));
        }

        void makeDead() {
            WeightedValue dead;
            WeightedValue current;
            while (!this.compareAndSet(current = (WeightedValue)this.get(), dead = new WeightedValue(current.value, 0))) {
            }
            ConcurrentLinkedHashMap.this.weightedSize.set(ConcurrentLinkedHashMap.this.weightedSize.get() - (long)Math.abs(current.weight));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WeightedValue<V> {
        final int weight;
        final V value;

        WeightedValue(V value, int weight) {
            this.weight = weight;
            this.value = value;
        }

        boolean contains(Object o) {
            return o == this.value || this.value.equals(o);
        }

        boolean isAlive() {
            return this.weight > 0;
        }

        boolean isRetired() {
            return this.weight < 0;
        }

        boolean isDead() {
            return this.weight == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DrainStatus {
        IDLE{

            boolean shouldDrainBuffers(boolean delayable) {
                return !delayable;
            }
        }
        ,
        REQUIRED{

            boolean shouldDrainBuffers(boolean delayable) {
                return true;
            }
        }
        ,
        PROCESSING{

            boolean shouldDrainBuffers(boolean delayable) {
                return false;
            }
        };


        abstract boolean shouldDrainBuffers(boolean var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class UpdateTask
    extends ReadTask {
        final int weightDifference;

        public UpdateTask(Node node, int weightDifference) {
            super(node);
            this.weightDifference = weightDifference;
        }

        @Override
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize.set(ConcurrentLinkedHashMap.this.weightedSize.get() + (long)this.weightDifference);
            super.run();
            ConcurrentLinkedHashMap.this.evict();
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class RemovalTask
    extends AbstractTask {
        final Node node;

        RemovalTask(Node node) {
            this.node = node;
        }

        @Override
        public void run() {
            ConcurrentLinkedHashMap.this.evictionDeque.remove(this.node);
            this.node.makeDead();
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AddTask
    extends AbstractTask {
        final Node node;
        final int weight;

        AddTask(Node node, int weight) {
            this.weight = weight;
            this.node = node;
        }

        @Override
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize.set(ConcurrentLinkedHashMap.this.weightedSize.get() + (long)this.weight);
            if (((WeightedValue)this.node.get()).isAlive()) {
                ConcurrentLinkedHashMap.this.evictionDeque.add(this.node);
                ConcurrentLinkedHashMap.this.evict();
            }
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReadTask
    extends AbstractTask {
        final Node node;

        ReadTask(Node node) {
            this.node = node;
        }

        @Override
        public void run() {
            if (ConcurrentLinkedHashMap.this.evictionDeque.contains(this.node)) {
                ConcurrentLinkedHashMap.this.evictionDeque.moveToBack(this.node);
            }
        }

        @Override
        public boolean isWrite() {
            return false;
        }
    }
}

