/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSequence
implements List<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> sequence;
    private final boolean cycle;
    private final boolean ignoreCase;

    public StringSequence(List<String> sequence) {
        this(sequence, true);
    }

    public StringSequence(List<String> sequence, boolean ignoreCase) {
        if (sequence == null || sequence.size() == 0) {
            throw new IllegalArgumentException("sequence == null");
        }
        ArrayList<String> list = new ArrayList<String>(sequence);
        boolean cycle = false;
        if (list.size() > 1 && ((String)list.get(0)).equals(list.get(list.size() - 1))) {
            cycle = true;
            list.remove(list.size() - 1);
        }
        this.sequence = list;
        this.cycle = cycle;
        this.ignoreCase = ignoreCase;
    }

    public List<String> getSequence() {
        return Collections.unmodifiableList(this.sequence);
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean containSequence(String begin, String end) {
        return this.indexOf(begin) != -1 && this.indexOf(end) != -1;
    }

    public List<String> getSequence(String begin, String end) {
        int beginIndex = this.indexOf(begin);
        int endIndex = this.indexOf(end);
        if (beginIndex == -1 || endIndex == -1) {
            return Arrays.asList(new String[0]);
        }
        if (beginIndex <= endIndex) {
            return Collections.unmodifiableList(this.sequence.subList(beginIndex, endIndex + 1));
        }
        if (this.cycle) {
            return Collections.unmodifiableList(this.cycleList(beginIndex, endIndex));
        }
        return Collections.unmodifiableList(this.reverseList(beginIndex, endIndex));
    }

    private List<String> cycleList(int beginIndex, int endIndex) {
        List<String> afterSub = this.sequence.subList(beginIndex, this.sequence.size());
        List<String> beforeSub = this.sequence.subList(0, endIndex + 1);
        ArrayList<String> sub = new ArrayList<String>(afterSub.size() + beforeSub.size());
        sub.addAll(afterSub);
        sub.addAll(beforeSub);
        sub = Collections.unmodifiableList(sub);
        return sub;
    }

    private List<String> reverseList(int beginIndex, int endIndex) {
        List<String> sub = this.sequence.subList(endIndex, beginIndex + 1);
        Collections.reverse(sub);
        return sub;
    }

    private int indexOf(String item) {
        if (this.ignoreCase) {
            int n = this.sequence.size();
            for (int i = 0; i < n; ++i) {
                if (!this.sequence.get(i).equalsIgnoreCase(item)) continue;
                return i;
            }
            return -1;
        }
        return this.sequence.indexOf(item);
    }

    @Override
    public void add(int index, String element) {
        this.sequence.add(index, element);
    }

    @Override
    public boolean add(String o) {
        return this.sequence.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        return this.sequence.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        return this.sequence.addAll(index, c);
    }

    @Override
    public void clear() {
        this.sequence.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.sequence.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.sequence.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.sequence.equals(o);
    }

    @Override
    public String get(int index) {
        return this.sequence.get(index);
    }

    @Override
    public int hashCode() {
        return this.sequence.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.sequence.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.sequence.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.sequence.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.sequence.lastIndexOf(o);
    }

    @Override
    public ListIterator<String> listIterator() {
        return this.sequence.listIterator();
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        return this.sequence.listIterator(index);
    }

    @Override
    public String remove(int index) {
        return this.sequence.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.sequence.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.sequence.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.sequence.retainAll(c);
    }

    @Override
    public String set(int index, String element) {
        return this.sequence.set(index, element);
    }

    @Override
    public int size() {
        return this.sequence.size();
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(this.sequence.subList(fromIndex, toIndex));
    }

    @Override
    public Object[] toArray() {
        return this.sequence.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.sequence.toArray(a);
    }

    public String toString() {
        return this.sequence.toString();
    }
}

