/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.ClassUtils;
import httl.util.CollectionUtils;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[+\\-]?[0-9]+(\\.[.0-9]+)?[BSILFDbsilfd]?$");
    private static final Pattern SYMBOL_PATTERN = Pattern.compile("[^(_a-zA-Z0-9)]");
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("[_a-zA-Z][\\._a-zA-Z0-9]+");
    private static final Pattern NAMED_PATTERN = Pattern.compile("^[_A-Za-z][_0-9A-Za-z]*$");
    private static final Pattern TYPED_PATTERN = Pattern.compile("^[_A-Za-z][_.0-9A-Za-z]*$");
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("^\\.[_A-Za-z][_0-9A-Za-z]*$");
    private static final Pattern COMMA_SPLIT_PATTERN = Pattern.compile("\\s*\\,\\s*");

    public static String getVaildName(String name) {
        return SYMBOL_PATTERN.matcher(name).replaceAll("_");
    }

    public static boolean isClassName(String value) {
        return StringUtils.isEmpty(value) ? false : CLASS_NAME_PATTERN.matcher(value).matches();
    }

    public static boolean isNumber(String value) {
        return StringUtils.isEmpty(value) ? false : NUMBER_PATTERN.matcher(value).matches();
    }

    public static boolean isNumber(char[] value) {
        if (value == null || value.length == 0) {
            return false;
        }
        for (char ch : value) {
            if (ch == '.' || ch > '0' && ch < '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(byte[] value) {
        if (value == null || value.length == 0) {
            return false;
        }
        for (byte ch : value) {
            if (ch == 46 || ch > 48 && ch < 57) continue;
            return false;
        }
        return true;
    }

    public static boolean isNamed(String value) {
        return NAMED_PATTERN.matcher(value).matches();
    }

    public static boolean isTyped(String value) {
        return TYPED_PATTERN.matcher(value).matches();
    }

    public static boolean isFunction(String value) {
        return FUNCTION_PATTERN.matcher(value).matches();
    }

    public static boolean isEmpty(byte[] value) {
        return value == null || value.length == 0;
    }

    public static boolean isNotEmpty(byte[] value) {
        return !StringUtils.isEmpty(value);
    }

    public static boolean isEmpty(char[] value) {
        return value == null || value.length == 0;
    }

    public static boolean isNotEmpty(char[] value) {
        return !StringUtils.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtils.isEmpty(value);
    }

    public static boolean isBlank(String value) {
        if (StringUtils.isNotEmpty(value)) {
            int len = value.length();
            block3: for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                switch (ch) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static boolean isNotBlank(String value) {
        return !StringUtils.isBlank(value);
    }

    public static String valueOf(Object value) {
        if (value == null) {
            return "";
        }
        return StringUtils.toString(value);
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (value instanceof boolean[]) {
                return Arrays.toString((boolean[])value);
            }
            if (value instanceof byte[]) {
                return Arrays.toString((byte[])value);
            }
            if (value instanceof short[]) {
                return Arrays.toString((short[])value);
            }
            if (value instanceof int[]) {
                return Arrays.toString((int[])value);
            }
            if (value instanceof long[]) {
                return Arrays.toString((long[])value);
            }
            if (value instanceof float[]) {
                return Arrays.toString((float[])value);
            }
            if (value instanceof double[]) {
                return Arrays.toString((double[])value);
            }
            if (value instanceof char[]) {
                return String.valueOf((char[])value);
            }
            if (value instanceof Object[]) {
                return Arrays.toString((Object[])value);
            }
        }
        return String.valueOf(value);
    }

    public static String toByteString(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 5);
        for (byte b : bytes) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(b);
        }
        return buf.toString();
    }

    public static String toCharString(char[] chars) {
        StringBuilder buf = new StringBuilder(chars.length * 4);
        for (char c : chars) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append('\'');
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\'': {
                    buf.append("\\'");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\f': {
                    buf.append("\\f");
                    break;
                }
                case '\b': {
                    buf.append("\b");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            buf.append('\'');
        }
        return buf.toString();
    }

    public static String escapeString(String src) {
        if (StringUtils.isEmpty(src)) {
            return src;
        }
        int len = src.length();
        StringBuilder buf = null;
        for (int i = 0; i < len; ++i) {
            String rep;
            char ch = src.charAt(i);
            switch (ch) {
                case '\\': {
                    rep = "\\\\";
                    break;
                }
                case '\"': {
                    rep = "\\\"";
                    break;
                }
                case '\'': {
                    rep = "\\'";
                    break;
                }
                case '\t': {
                    rep = "\\t";
                    break;
                }
                case '\n': {
                    rep = "\\n";
                    break;
                }
                case '\r': {
                    rep = "\\r";
                    break;
                }
                case '\b': {
                    rep = "\\b";
                    break;
                }
                case '\f': {
                    rep = "\\f";
                    break;
                }
                default: {
                    rep = null;
                }
            }
            if (rep != null) {
                if (buf == null) {
                    buf = new StringBuilder(len * 2);
                    if (i > 0) {
                        buf.append(src.substring(0, i));
                    }
                }
                buf.append(rep);
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            return buf.toString();
        }
        return src;
    }

    public static char[] escapeString(char[] src) {
        if (src == null || src.length == 0) {
            return src;
        }
        int len = src.length;
        int off = 0;
        char[] buf = null;
        for (int i = 0; i < len; ++i) {
            int rep;
            char ch = src[i];
            switch (ch) {
                case '\\': {
                    rep = 92;
                    break;
                }
                case '\"': {
                    rep = 34;
                    break;
                }
                case '\'': {
                    rep = 39;
                    break;
                }
                case '\t': {
                    rep = 116;
                    break;
                }
                case '\n': {
                    rep = 110;
                    break;
                }
                case '\r': {
                    rep = 114;
                    break;
                }
                case '\b': {
                    rep = 98;
                    break;
                }
                case '\f': {
                    rep = 102;
                    break;
                }
                default: {
                    rep = 0;
                }
            }
            if (rep != 0) {
                if (buf == null) {
                    off = i;
                    buf = StringUtils.expand(src, off, 2);
                }
                buf[off++] = 92;
                buf[off++] = rep;
                continue;
            }
            if (buf == null) continue;
            buf[off++] = ch;
        }
        if (buf != null) {
            if (buf.length > off) {
                char[] newBuf = new char[off];
                System.arraycopy(buf, 0, newBuf, 0, off);
                return newBuf;
            }
            return buf;
        }
        return src;
    }

    public static byte[] escapeString(byte[] src) {
        if (src == null || src.length == 0) {
            return src;
        }
        int len = src.length;
        int off = 0;
        byte[] buf = null;
        int pre = 0;
        for (int i = 0; i < len; ++i) {
            int rep;
            int ch = src[i];
            switch (ch) {
                case 92: {
                    rep = 92;
                    break;
                }
                case 34: {
                    rep = 34;
                    break;
                }
                case 39: {
                    rep = 39;
                    break;
                }
                case 9: {
                    rep = 116;
                    break;
                }
                case 10: {
                    rep = 110;
                    break;
                }
                case 13: {
                    rep = 114;
                    break;
                }
                case 8: {
                    rep = 98;
                    break;
                }
                case 12: {
                    rep = 102;
                    break;
                }
                default: {
                    rep = 0;
                }
            }
            if (rep != 0 && pre >= 0) {
                if (buf == null) {
                    off = i;
                    buf = StringUtils.expand(src, off, 2);
                }
                buf[off++] = 92;
                buf[off++] = rep;
            } else if (buf != null) {
                buf[off++] = ch;
            }
            pre = ch;
        }
        if (buf != null) {
            if (buf.length > off) {
                byte[] newBuf = new byte[off];
                System.arraycopy(buf, 0, newBuf, 0, off);
                return newBuf;
            }
            return buf;
        }
        return src;
    }

    public static String unescapeString(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        StringBuilder buf = null;
        int len = value.length();
        int len1 = len - 1;
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch == '\\' && i < len1) {
                int j = i++;
                ch = value.charAt(i);
                switch (ch) {
                    case '\\': {
                        ch = '\\';
                        break;
                    }
                    case '\"': {
                        ch = '\"';
                        break;
                    }
                    case '\'': {
                        ch = '\'';
                        break;
                    }
                    case 't': {
                        ch = '\t';
                        break;
                    }
                    case 'n': {
                        ch = '\n';
                        break;
                    }
                    case 'r': {
                        ch = '\r';
                        break;
                    }
                    case 'b': {
                        ch = '\b';
                        break;
                    }
                    case 'f': {
                        ch = '\f';
                        break;
                    }
                    default: {
                        --j;
                    }
                }
                if (buf == null) {
                    buf = new StringBuilder(len);
                    if (j > 0) {
                        buf.append(value.substring(0, j));
                    }
                }
                buf.append(ch);
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            return buf.toString();
        }
        return value;
    }

    public static String escapeXml(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        int len = value.length();
        StringBuilder buf = null;
        block7: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '<': {
                    if (buf == null) {
                        buf = new StringBuilder(len * 2);
                        if (i > 0) {
                            buf.append(value.substring(0, i));
                        }
                    }
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    if (buf == null) {
                        buf = new StringBuilder(len * 2);
                        if (i > 0) {
                            buf.append(value.substring(0, i));
                        }
                    }
                    buf.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    if (buf == null) {
                        buf = new StringBuilder(len * 2);
                        if (i > 0) {
                            buf.append(value.substring(0, i));
                        }
                    }
                    buf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    if (buf == null) {
                        buf = new StringBuilder(len * 2);
                        if (i > 0) {
                            buf.append(value.substring(0, i));
                        }
                    }
                    buf.append("&apos;");
                    continue block7;
                }
                case '&': {
                    if (buf == null) {
                        buf = new StringBuilder(len * 2);
                        if (i > 0) {
                            buf.append(value.substring(0, i));
                        }
                    }
                    buf.append("&amp;");
                    continue block7;
                }
                default: {
                    if (buf == null) continue block7;
                    buf.append(ch);
                }
            }
        }
        if (buf != null) {
            return buf.toString();
        }
        return value;
    }

    public static char[] escapeXml(char[] src) {
        if (src == null || src.length == 0) {
            return src;
        }
        int len = src.length;
        int off = 0;
        char[] buf = null;
        block7: for (int i = 0; i < len; ++i) {
            char ch = src[i];
            switch (ch) {
                case '<': {
                    if (buf == null) {
                        off = i;
                        buf = StringUtils.expand(src, off, 4);
                    } else if (buf.length < off + 4) {
                        buf = StringUtils.expand(buf, off, 4);
                    }
                    buf[off++] = 38;
                    buf[off++] = 108;
                    buf[off++] = 116;
                    buf[off++] = 59;
                    continue block7;
                }
                case '>': {
                    if (buf == null) {
                        off = i;
                        buf = StringUtils.expand(src, off, 4);
                    } else if (buf.length < off + 4) {
                        buf = StringUtils.expand(buf, off, 4);
                    }
                    buf[off++] = 38;
                    buf[off++] = 103;
                    buf[off++] = 116;
                    buf[off++] = 59;
                    continue block7;
                }
                case '\"': {
                    if (buf == null) {
                        off = i;
                        buf = StringUtils.expand(src, off, 6);
                    } else if (buf.length < off + 6) {
                        buf = StringUtils.expand(buf, off, 6);
                    }
                    buf[off++] = 38;
                    buf[off++] = 113;
                    buf[off++] = 117;
                    buf[off++] = 111;
                    buf[off++] = 116;
                    buf[off++] = 59;
                    continue block7;
                }
                case '\'': {
                    if (buf == null) {
                        off = i;
                        buf = StringUtils.expand(src, off, 6);
                    } else if (buf.length < off + 6) {
                        buf = StringUtils.expand(buf, off, 6);
                    }
                    buf[off++] = 38;
                    buf[off++] = 97;
                    buf[off++] = 112;
                    buf[off++] = 111;
                    buf[off++] = 115;
                    buf[off++] = 59;
                    continue block7;
                }
                case '&': {
                    if (buf == null) {
                        off = i;
                        buf = StringUtils.expand(src, off, 5);
                    } else if (buf.length < off + 5) {
                        buf = StringUtils.expand(buf, off, 5);
                    }
                    buf[off++] = 38;
                    buf[off++] = 97;
                    buf[off++] = 109;
                    buf[off++] = 112;
                    buf[off++] = 59;
                    continue block7;
                }
                default: {
                    if (buf == null) continue block7;
                    if (buf.length < off + 1) {
                        buf = StringUtils.expand(buf, off, 1);
                    }
                    buf[off++] = ch;
                }
            }
        }
        if (buf != null) {
            if (buf.length > off) {
                char[] newBuf = new char[off];
                System.arraycopy(buf, 0, newBuf, 0, off);
                return newBuf;
            }
            return buf;
        }
        return src;
    }

    public static byte[] escapeXml(byte[] src) {
        if (src == null || src.length == 0) {
            return src;
        }
        int len = src.length;
        int off = 0;
        byte[] buf = null;
        block7: for (int i = 0; i < len; ++i) {
            byte ch = src[i];
            switch (ch) {
                case 60: {
                    if (buf == null) {
                        off = i;
                        buf = StringUtils.expand(src, off, 4);
                    } else if (buf.length < off + 4) {
                        buf = StringUtils.expand(buf, off, 4);
                    }
                    buf[off++] = 38;
                    buf[off++] = 108;
                    buf[off++] = 116;
                    buf[off++] = 59;
                    continue block7;
                }
                case 62: {
                    if (buf == null) {
                        off = i;
                        buf = StringUtils.expand(src, off, 4);
                    } else if (buf.length < off + 4) {
                        buf = StringUtils.expand(buf, off, 4);
                    }
                    buf[off++] = 38;
                    buf[off++] = 103;
                    buf[off++] = 116;
                    buf[off++] = 59;
                    continue block7;
                }
                case 34: {
                    if (buf == null) {
                        off = i;
                        buf = StringUtils.expand(src, off, 6);
                    } else if (buf.length < off + 6) {
                        buf = StringUtils.expand(buf, off, 6);
                    }
                    buf[off++] = 38;
                    buf[off++] = 113;
                    buf[off++] = 117;
                    buf[off++] = 111;
                    buf[off++] = 116;
                    buf[off++] = 59;
                    continue block7;
                }
                case 39: {
                    if (buf == null) {
                        off = i;
                        buf = StringUtils.expand(src, off, 6);
                    } else if (buf.length < off + 6) {
                        buf = StringUtils.expand(buf, off, 6);
                    }
                    buf[off++] = 38;
                    buf[off++] = 97;
                    buf[off++] = 112;
                    buf[off++] = 111;
                    buf[off++] = 115;
                    buf[off++] = 59;
                    continue block7;
                }
                case 38: {
                    if (buf == null) {
                        off = i;
                        buf = StringUtils.expand(src, off, 5);
                    } else if (buf.length < off + 5) {
                        buf = StringUtils.expand(buf, off, 5);
                    }
                    buf[off++] = 38;
                    buf[off++] = 97;
                    buf[off++] = 109;
                    buf[off++] = 112;
                    buf[off++] = 59;
                    continue block7;
                }
                default: {
                    if (buf == null) continue block7;
                    if (buf.length < off + 1) {
                        buf = StringUtils.expand(buf, off, 1);
                    }
                    buf[off++] = ch;
                }
            }
        }
        if (buf != null) {
            if (buf.length > off) {
                byte[] newBuf = new byte[off];
                System.arraycopy(buf, 0, newBuf, 0, off);
                return newBuf;
            }
            return buf;
        }
        return src;
    }

    private static char[] expand(char[] src, int off, int inc) {
        int len = Math.max(src.length * 2, off + inc);
        char[] dest = new char[len];
        if (off > 0) {
            System.arraycopy(src, 0, dest, 0, off);
        }
        return dest;
    }

    private static byte[] expand(byte[] src, int off, int inc) {
        int len = Math.max(src.length * 2, off + inc);
        byte[] dest = new byte[len];
        if (off > 0) {
            System.arraycopy(src, 0, dest, 0, off);
        }
        return dest;
    }

    public static String unescapeXml(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        StringBuilder buf = null;
        int len = value.length();
        int len3 = len - 3;
        int len4 = len - 4;
        int len5 = len - 5;
        block6: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch == '&' && i < len3) {
                int j = i;
                char ch1 = value.charAt(i + 1);
                switch (ch1) {
                    case 'l': {
                        if (value.charAt(i + 2) == 't' && value.charAt(i + 3) == ';') {
                            i += 3;
                            if (buf == null) {
                                buf = new StringBuilder(len3);
                                if (j > 0) {
                                    buf.append(value.substring(0, j));
                                }
                            }
                            buf.append('<');
                            break;
                        }
                        if (buf == null) continue block6;
                        buf.append('&');
                        break;
                    }
                    case 'g': {
                        if (value.charAt(i + 2) == 't' && value.charAt(i + 3) == ';') {
                            i += 3;
                            if (buf == null) {
                                buf = new StringBuilder(len3);
                                if (j > 0) {
                                    buf.append(value.substring(0, j));
                                }
                            }
                            buf.append('>');
                            break;
                        }
                        if (buf == null) continue block6;
                        buf.append('&');
                        break;
                    }
                    case 'a': {
                        if (i < len4 && value.charAt(i + 2) == 'm' && value.charAt(i + 3) == 'p' && value.charAt(i + 4) == ';') {
                            i += 4;
                            if (buf == null) {
                                buf = new StringBuilder(len4);
                                if (j > 0) {
                                    buf.append(value.substring(0, j));
                                }
                            }
                            buf.append('&');
                            break;
                        }
                        if (i < len5 && value.charAt(i + 2) == 'p' && value.charAt(i + 3) == 'o' && value.charAt(i + 4) == 's' && value.charAt(i + 5) == ';') {
                            i += 5;
                            if (buf == null) {
                                buf = new StringBuilder(len5);
                                if (j > 0) {
                                    buf.append(value.substring(0, j));
                                }
                            }
                            buf.append('\'');
                            break;
                        }
                        if (buf == null) continue block6;
                        buf.append('&');
                        break;
                    }
                    case 'q': {
                        if (i < len5 && value.charAt(i + 2) == 'u' && value.charAt(i + 3) == 'o' && value.charAt(i + 4) == 't' && value.charAt(i + 5) == ';') {
                            i += 5;
                            if (buf == null) {
                                buf = new StringBuilder(len5);
                                if (j > 0) {
                                    buf.append(value.substring(0, j));
                                }
                            }
                            buf.append('\"');
                            break;
                        }
                        if (buf == null) continue block6;
                        buf.append('&');
                        break;
                    }
                    default: {
                        if (buf == null) continue block6;
                        buf.append('&');
                        break;
                    }
                }
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            return buf.toString();
        }
        return value;
    }

    public static String clearBlank(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        int len = value.length();
        StringBuilder buf = null;
        boolean blank = false;
        block3: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (blank) continue block3;
                    blank = true;
                    if (buf != null) continue block3;
                    buf = new StringBuilder(len);
                    if (i <= 0) continue block3;
                    buf.append(value.substring(0, i));
                    continue block3;
                }
                default: {
                    if (blank) {
                        blank = false;
                    }
                    if (buf == null) continue block3;
                    buf.append(ch);
                }
            }
        }
        if (buf != null) {
            return buf.toString();
        }
        return value;
    }

    public static String compressBlank(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        int len = value.length();
        StringBuilder buf = null;
        boolean blank = false;
        block3: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (blank) continue block3;
                    blank = true;
                    if (buf == null) {
                        buf = new StringBuilder(len);
                        if (i > 0) {
                            buf.append(value.substring(0, i));
                        }
                    }
                    buf.append(' ');
                    continue block3;
                }
                default: {
                    if (blank) {
                        blank = false;
                    }
                    if (buf == null) continue block3;
                    buf.append(ch);
                }
            }
        }
        if (buf != null) {
            return buf.toString();
        }
        return value;
    }

    public static String trimBlankLine(String value, boolean left, boolean right) {
        if (value == null || value.isEmpty() || !left && !right) {
            return value;
        }
        int len = value.length();
        int start = 0;
        if (left) {
            block10: for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                switch (ch) {
                    case '\b': 
                    case '\t': 
                    case '\f': 
                    case ' ': {
                        continue block10;
                    }
                    case '\n': {
                        start = i + 1;
                        break block10;
                    }
                    case '\r': {
                        int next = i + 1;
                        if (next < len && value.charAt(next) == '\n') {
                            start = i + 2;
                            break block10;
                        }
                        start = i + 1;
                        break block10;
                    }
                }
            }
        }
        int end = len;
        if (right) {
            int len1 = len - 1;
            int start1 = start > 0 ? start - 1 : 0;
            block11: for (int i = len1; i >= start1; --i) {
                char ch = value.charAt(i);
                switch (ch) {
                    case '\b': 
                    case '\t': 
                    case '\f': 
                    case ' ': {
                        continue block11;
                    }
                    case '\n': {
                        end = i + 1;
                        break block11;
                    }
                    case '\r': {
                        end = i + 1;
                        break block11;
                    }
                }
            }
        }
        if (start == end) {
            return "";
        }
        if (start > 0 || end < len) {
            return value.substring(start, end);
        }
        return value;
    }

    public static String trimBlankLine(String value) {
        return StringUtils.trimBlankLine(value, true, true);
    }

    public static String trimLeftBlankLine(String value) {
        return StringUtils.trimBlankLine(value, true, false);
    }

    public static String trimRightBlankLine(String value) {
        return StringUtils.trimBlankLine(value, false, true);
    }

    public static String clearBlankLine(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        int len = value.length();
        int len1 = len - 1;
        StringBuilder buf = null;
        int pre = 0;
        boolean blank = true;
        block4: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (buf != null) {
                buf.append(ch);
            }
            switch (ch) {
                case '\b': 
                case '\t': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (i < len1) continue block4;
                }
                case '\n': {
                    if (blank) {
                        if (buf == null) {
                            buf = new StringBuilder(len);
                            if (pre > 0) {
                                buf.append(value.substring(0, pre + 1));
                            }
                        } else {
                            buf.setLength(buf.length() - i + pre);
                        }
                    } else {
                        blank = true;
                    }
                    pre = i;
                    continue block4;
                }
                default: {
                    if (!blank) continue block4;
                    blank = false;
                }
            }
        }
        if (buf != null) {
            return buf.toString();
        }
        return value;
    }

    public static String getConditionCode(Class<?> type, String code, String[] sizers) throws ParseException {
        if (type != Boolean.TYPE) {
            String method;
            code = type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE ? "(" + code + ") != 0" : (type == Character.TYPE ? "(" + code + ") != '\\0'" : (type == String.class ? "(" + code + ")  != null && (" + code + ").length() > 0" : (type == Boolean.class ? "(" + code + ")  != null && (" + code + ").booleanValue()" : (type.isArray() ? "(" + code + ") != null && (" + code + ").length > 0" : (Collection.class.isAssignableFrom(type) ? "(" + code + ") != null && (" + code + ").size() > 0" : (Map.class.isAssignableFrom(type) ? "(" + code + ") != null && (" + code + ").size() > 0" : (StringUtils.isNotEmpty(method = ClassUtils.getSizeMethod(type, sizers)) ? "(" + code + ") != null && (" + code + ")." + method + " > 0" : ClassUtils.class.getCanonicalName() + ".isTrue(" + code + ")")))))));
        }
        return code;
    }

    public static String getLocationMessage(String name, Reader reader, int offset) {
        String location = "";
        if (offset <= 0) {
            return location;
        }
        try {
            int line = 1;
            int column = 0;
            int count = 0;
            int len = 0;
            char[] buf = new char[128];
            StringBuilder cur = new StringBuilder();
            while ((len = reader.read(buf)) > 0) {
                for (int i = 0; i < len; ++i) {
                    char ch = buf[i];
                    if (ch == '\n') {
                        ++line;
                        column = 0;
                        cur.setLength(0);
                    } else {
                        ++column;
                        cur.append(ch);
                    }
                    if (count >= offset) {
                        int j;
                        char[] b;
                        int l;
                        int padding = 20;
                        String before = cur.length() <= padding ? cur.toString() : cur.substring(cur.length() - padding);
                        int c = i + 1;
                        int remain = len - c;
                        StringBuilder after = new StringBuilder();
                        boolean breaked = false;
                        if (remain > 0) {
                            for (int j2 = c; j2 < padding + c && j2 < buf.length; ++j2) {
                                if (buf[j2] == '\r' || buf[j2] == '\n') {
                                    breaked = true;
                                    break;
                                }
                                after.append(buf[j2]);
                            }
                        }
                        if (!breaked && remain < padding && (l = reader.read(b = new char[padding - remain])) > 0) {
                            for (int j3 = 0; j3 < l && b[j3] != '\r' && b[j3] != '\n'; ++j3) {
                                after.append(b[j3]);
                            }
                        }
                        StringBuilder msg = new StringBuilder();
                        msg.append("line: " + line + ", column: " + column + ", char: " + ch + ", in: \n" + name + "\n");
                        for (j = 0; j < padding * 2; ++j) {
                            msg.append("=");
                        }
                        msg.append("\n");
                        msg.append("...");
                        msg.append(before);
                        msg.append((CharSequence)after);
                        msg.append("...");
                        msg.append("\n");
                        for (j = 0; j < before.length() + 2; ++j) {
                            msg.append(" ");
                        }
                        msg.append("^-here\n");
                        for (j = 0; j < padding * 2; ++j) {
                            msg.append("=");
                        }
                        msg.append("\n");
                        return msg.toString();
                    }
                    ++count;
                }
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return location;
    }

    public static String removeCommaValue(String values, String value) {
        return StringUtils.joinByComma(CollectionUtils.remove(StringUtils.splitByComma(values), value));
    }

    public static String joinByComma(String[] values) {
        return StringUtils.joinBy(values, ",");
    }

    public static String joinBy(String[] values, String sep) {
        StringBuilder buf = new StringBuilder();
        for (String value : values) {
            if (buf.length() > 0) {
                buf.append(sep);
            }
            buf.append(value);
        }
        return buf.toString();
    }

    public static String[] splitByComma(String name) {
        return name == null ? new String[]{} : COMMA_SPLIT_PATTERN.split(name);
    }

    public static String splitCamelName(String name, String split) {
        return StringUtils.splitCamelName(name, split, false);
    }

    public static String splitCamelName(String name, String split, boolean upper) {
        if (StringUtils.isEmpty(name)) {
            return name;
        }
        StringBuilder buf = new StringBuilder(name.length() * 2);
        buf.append(upper ? Character.toUpperCase(name.charAt(0)) : Character.toLowerCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                buf.append(split);
                buf.append(upper ? c : Character.toLowerCase(c));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static byte[] toBytes(String src, String encoding) {
        try {
            return src.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            return src.getBytes();
        }
    }

    public static boolean endsWith(String value, String[] suffixes) {
        if (value != null && suffixes != null) {
            for (String suffix : suffixes) {
                if (!value.endsWith(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean inArray(String value, String[] values) {
        if (value != null && values != null) {
            value = value.trim();
            for (String v : values) {
                if (!value.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    public static String concat(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v1 == null) {
            return String.valueOf(v2);
        }
        if (v2 == null) {
            return String.valueOf(v1);
        }
        return String.valueOf(v1) + String.valueOf(v2);
    }
}

