/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.StringUtils;

public final class Token {
    public static final int UNKNOWN_TYPE = -1;
    private final String message;
    private final int offset;
    private final int type;

    public Token(String message, int offset) {
        this(message, offset, -1);
    }

    public Token(String message, int offset, int type) {
        if (StringUtils.isEmpty(message)) {
            throw new IllegalArgumentException("message == null");
        }
        this.message = message;
        this.offset = offset;
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return this.message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + this.offset;
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return this.type == other.type;
    }
}

