/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import java.io.IOException;
import java.io.Reader;

public class UnsafeStringReader
extends Reader {
    private String string;
    private int position;
    private int limit;
    private int mark;

    public UnsafeStringReader(String str) {
        this.string = str;
        this.limit = str.length();
        this.mark = 0;
        this.position = 0;
    }

    public int read() throws IOException {
        this.ensureOpen();
        if (this.position >= this.limit) {
            return -1;
        }
        return this.string.charAt(this.position++);
    }

    public int read(char[] cs, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > cs.length || len < 0 || off + len > cs.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.position >= this.limit) {
            return -1;
        }
        int n = Math.min(this.limit - this.position, len);
        this.string.getChars(this.position, this.position + n, cs, off);
        this.position += n;
        return n;
    }

    public long skip(long ns) throws IOException {
        this.ensureOpen();
        if (this.position >= this.limit) {
            return 0L;
        }
        long n = Math.min((long)(this.limit - this.position), ns);
        n = Math.max((long)(-this.position), n);
        this.position = (int)((long)this.position + n);
        return n;
    }

    public boolean ready() throws IOException {
        this.ensureOpen();
        return true;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.ensureOpen();
        this.mark = this.position;
    }

    public void reset() throws IOException {
        this.ensureOpen();
        this.position = this.mark;
    }

    public void close() throws IOException {
        this.string = null;
    }

    private void ensureOpen() throws IOException {
        if (this.string == null) {
            throw new IOException("Stream closed");
        }
    }
}

